/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.I0Itec.zkclient.ZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalViewReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalViewReader.class);
    private static final ObjectReader OBJECT_READER = new ObjectMapper().reader();
    private ZkClient zkClient;
    public static String BROKER_EXTERNAL_VIEW_PATH = "/EXTERNALVIEW/brokerResource";
    public static String REALTIME_SUFFIX = "_REALTIME";
    public static String OFFLINE_SUFFIX = "_OFFLINE";

    public ExternalViewReader(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public List<String> getLiveBrokers() {
        ArrayList<String> brokerUrls = new ArrayList<String>();
        try {
            byte[] brokerResourceNodeData = (byte[])this.zkClient.readData(BROKER_EXTERNAL_VIEW_PATH, true);
            brokerResourceNodeData = ExternalViewReader.unpackZnodeIfNecessary(brokerResourceNodeData);
            JsonNode jsonObject = OBJECT_READER.readTree((InputStream)this.getInputStream(brokerResourceNodeData));
            JsonNode brokerResourceNode = jsonObject.get("mapFields");
            Iterator resourceEntries = brokerResourceNode.fields();
            while (resourceEntries.hasNext()) {
                JsonNode resource = (JsonNode)((Map.Entry)resourceEntries.next()).getValue();
                Iterator brokerEntries = resource.fields();
                while (brokerEntries.hasNext()) {
                    Map.Entry brokerEntry = (Map.Entry)brokerEntries.next();
                    String brokerName = (String)brokerEntry.getKey();
                    if (!brokerName.startsWith("Broker_") || !"ONLINE".equals(((JsonNode)brokerEntry.getValue()).asText())) continue;
                    String brokerHostPort = brokerName.replace("Broker_", "").replace("_", ":");
                    brokerUrls.add(brokerHostPort);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading External view from zookeeper", (Throwable)e);
        }
        return brokerUrls;
    }

    protected ByteArrayInputStream getInputStream(byte[] brokerResourceNodeData) {
        return new ByteArrayInputStream(brokerResourceNodeData);
    }

    public Map<String, List<String>> getTableToBrokersMap() {
        HashMap<String, Set> brokerUrlsMap = new HashMap<String, Set>();
        try {
            byte[] brokerResourceNodeData = (byte[])this.zkClient.readData("/EXTERNALVIEW/brokerResource", true);
            brokerResourceNodeData = ExternalViewReader.unpackZnodeIfNecessary(brokerResourceNodeData);
            JsonNode jsonObject = OBJECT_READER.readTree((InputStream)this.getInputStream(brokerResourceNodeData));
            JsonNode brokerResourceNode = jsonObject.get("mapFields");
            Iterator resourceEntries = brokerResourceNode.fields();
            while (resourceEntries.hasNext()) {
                Map.Entry resourceEntry = (Map.Entry)resourceEntries.next();
                String resourceName = (String)resourceEntry.getKey();
                String tableName = resourceName.replace(OFFLINE_SUFFIX, "").replace(REALTIME_SUFFIX, "");
                Set brokerUrls = brokerUrlsMap.computeIfAbsent(tableName, k -> new HashSet());
                JsonNode resource = (JsonNode)resourceEntry.getValue();
                Iterator brokerEntries = resource.fields();
                while (brokerEntries.hasNext()) {
                    Map.Entry brokerEntry = (Map.Entry)brokerEntries.next();
                    String brokerName = (String)brokerEntry.getKey();
                    if (!brokerName.startsWith("Broker_") || !"ONLINE".equals(((JsonNode)brokerEntry.getValue()).asText())) continue;
                    String brokerHostPort = brokerName.replace("Broker_", "").replace("_", ":");
                    brokerUrls.add(brokerHostPort);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading External view from zookeeper", (Throwable)e);
        }
        HashMap<String, List<String>> tableToBrokersMap = new HashMap<String, List<String>>();
        for (Map.Entry entry : brokerUrlsMap.entrySet()) {
            tableToBrokersMap.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return tableToBrokersMap;
    }

    private static byte[] unpackZnodeIfNecessary(byte[] znodeContents) {
        if (znodeContents[0] == 31 && znodeContents[1] == -117) {
            try {
                GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(znodeContents));
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                int byteRead = inputStream.read();
                while (byteRead != -1) {
                    outputStream.write(byteRead);
                    byteRead = inputStream.read();
                }
                return outputStream.toByteArray();
            }
            catch (IOException e) {
                LOGGER.error("Failed to decompress znode contents", (Throwable)e);
                return znodeContents;
            }
        }
        return znodeContents;
    }
}

