/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.client.BrokerResponse;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonAsyncHttpPinotClientTransport
implements PinotClientTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonAsyncHttpPinotClientTransport.class);
    private static final ObjectReader OBJECT_READER = new ObjectMapper().reader();
    AsyncHttpClient _httpClient = new AsyncHttpClient();
    Map<String, String> _headers;

    public JsonAsyncHttpPinotClientTransport() {
    }

    public JsonAsyncHttpPinotClientTransport(Map<String, String> headers) {
        this._headers = headers;
    }

    @Override
    public BrokerResponse executeQuery(String brokerAddress, String query) throws PinotClientException {
        try {
            return this.executeQueryAsync(brokerAddress, query).get();
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    @Override
    public Future<BrokerResponse> executeQueryAsync(String brokerAddress, String query) {
        return this.executeQueryAsync(brokerAddress, new Request("pql", query));
    }

    public Future<BrokerResponse> executePinotQueryAsync(String brokerAddress, Request request) {
        try {
            String url;
            ObjectNode json = JsonNodeFactory.instance.objectNode();
            String queryFormat = request.getQueryFormat();
            json.put(queryFormat, request.getQuery());
            if (queryFormat.equalsIgnoreCase("sql")) {
                url = "http://" + brokerAddress + "/query/sql";
                json.put("queryOptions", "groupByMode=sql;responseFormat=sql");
            } else {
                url = "http://" + brokerAddress + "/query";
            }
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this._httpClient.preparePost(url);
            if (this._headers != null) {
                this._headers.forEach((k, v) -> requestBuilder.addHeader(k, v));
            }
            ListenableFuture response = requestBuilder.addHeader("Content-Type", "application/json; charset=utf-8").setBody(json.toString()).execute();
            return new BrokerResponseFuture((Future<Response>)response, request.getQuery(), url);
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    @Override
    public BrokerResponse executeQuery(String brokerAddress, Request request) throws PinotClientException {
        try {
            return this.executeQueryAsync(brokerAddress, request).get();
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    @Override
    public Future<BrokerResponse> executeQueryAsync(String brokerAddress, Request request) throws PinotClientException {
        return this.executePinotQueryAsync(brokerAddress, request);
    }

    @Override
    public void close() throws PinotClientException {
        if (this._httpClient.isClosed()) {
            throw new PinotClientException("Connection is already closed!");
        }
        this._httpClient.close();
    }

    private static class BrokerResponseFuture
    implements Future<BrokerResponse> {
        private final Future<Response> _response;
        private final String _query;
        private final String _url;

        public BrokerResponseFuture(Future<Response> response, String query, String url) {
            this._response = response;
            this._query = query;
            this._url = url;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this._response.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this._response.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._response.isDone();
        }

        @Override
        public BrokerResponse get() throws ExecutionException {
            return this.get(1000L, TimeUnit.DAYS);
        }

        @Override
        public BrokerResponse get(long timeout, TimeUnit unit) throws ExecutionException {
            try {
                LOGGER.debug("Sending query {} to {}", (Object)this._query, (Object)this._url);
                Response httpResponse = this._response.get(timeout, unit);
                LOGGER.debug("Completed query, HTTP status is {}", (Object)httpResponse.getStatusCode());
                if (httpResponse.getStatusCode() != 200) {
                    throw new PinotClientException("Pinot returned HTTP status " + httpResponse.getStatusCode() + ", expected 200");
                }
                String responseBody = httpResponse.getResponseBody("UTF-8");
                return BrokerResponse.fromJson(OBJECT_READER.readTree(responseBody));
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }
}

