/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.client.AggregationResultSet;
import org.apache.pinot.client.BrokerResponse;
import org.apache.pinot.client.ExecutionStats;
import org.apache.pinot.client.GroupByResultSet;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.ResultSet;
import org.apache.pinot.client.ResultTableResultSet;
import org.apache.pinot.client.SelectionResultSet;

public class ResultSetGroup {
    private final List<ResultSet> _resultSets = new ArrayList<ResultSet>();
    private final ExecutionStats _executionStats;

    ResultSetGroup(BrokerResponse brokerResponse) {
        if (brokerResponse.getResultTable() != null) {
            this._resultSets.add(new ResultTableResultSet(brokerResponse.getResultTable()));
        } else {
            if (brokerResponse.getSelectionResults() != null) {
                this._resultSets.add(new SelectionResultSet(brokerResponse.getSelectionResults()));
            }
            int aggregationResultCount = brokerResponse.getAggregationResultsSize();
            for (int i = 0; i < aggregationResultCount; ++i) {
                JsonNode aggregationResult = brokerResponse.getAggregationResults().get(i);
                if (aggregationResult.has("value")) {
                    this._resultSets.add(new AggregationResultSet(aggregationResult));
                    continue;
                }
                if (aggregationResult.has("groupByResult")) {
                    this._resultSets.add(new GroupByResultSet(aggregationResult));
                    continue;
                }
                throw new PinotClientException("Unrecognized result group, neither a value nor group by result");
            }
        }
        this._executionStats = brokerResponse.getExecutionStats();
    }

    public int getResultSetCount() {
        return this._resultSets.size();
    }

    public ResultSet getResultSet(int index) {
        return this._resultSets.get(index);
    }

    public ExecutionStats getExecutionStats() {
        return this._executionStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ResultSet resultSet : this._resultSets) {
            sb.append(resultSet);
            sb.append("\n");
        }
        sb.append(this._executionStats.toString());
        return sb.toString();
    }
}

