/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.LinkedList;
import java.util.List;

public class TextTable {
    private List<String[]> rows = new LinkedList<String[]>();
    private String[] headerColumnNames;
    private static final char PAD_CHAR = ' ';

    public void addHeader(String ... headerColumnNames) {
        this.headerColumnNames = headerColumnNames;
    }

    public void addRow(String ... columnValues) {
        this.rows.add(columnValues);
    }

    private int[] colWidths() {
        int cols = 0;
        if (this.headerColumnNames != null) {
            cols = this.headerColumnNames.length;
        }
        for (String[] row : this.rows) {
            cols = Math.max(cols, row.length);
        }
        int[] widths = new int[cols];
        if (this.headerColumnNames != null) {
            this.updateWidths(widths, this.headerColumnNames);
        }
        for (String[] row : this.rows) {
            this.updateWidths(widths, row);
        }
        return widths;
    }

    private void updateWidths(int[] widths, String[] values) {
        for (int colNum = 0; colNum < values.length; ++colNum) {
            int length = 0;
            if (values[colNum] != null) {
                length = values[colNum].getBytes().length;
            }
            widths[colNum] = Math.max(widths[colNum], length);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int[] colWidths = this.colWidths();
        if (this.headerColumnNames != null) {
            this.append(buf, colWidths, this.headerColumnNames);
            int totalWidth = 0;
            for (int width : colWidths) {
                totalWidth += width;
            }
            buf.append(TextTable.rightPad("", totalWidth, '='));
            buf.append('\n');
        }
        for (String[] row : this.rows) {
            this.append(buf, colWidths, row);
        }
        return buf.toString();
    }

    private void append(StringBuilder buf, int[] colWidths, String[] row) {
        for (int colNum = 0; colNum < row.length; ++colNum) {
            buf.append(TextTable.rightPad(row[colNum], colWidths[colNum], ' '));
            buf.append(' ');
        }
        buf.append('\n');
    }

    public static String rightPad(String str, int size, char padChar) {
        int i;
        int pads;
        int length = 0;
        if (str != null) {
            length = str.length();
        }
        if ((pads = size - length) <= 0) {
            return str;
        }
        char[] buf = new char[size];
        for (i = 0; i < length; ++i) {
            buf[i] = str.charAt(i);
        }
        for (i = str.length(); i < size; ++i) {
            buf[i] = padChar;
        }
        return String.valueOf(buf);
    }
}

