/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.AbstractResultSet;
import org.apache.pinot.client.TextTable;

class AggregationResultSet
extends AbstractResultSet {
    private final JsonNode _jsonObject;

    public AggregationResultSet(JsonNode jsonObject) {
        this._jsonObject = jsonObject;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this._jsonObject.get("function").asText();
    }

    @Override
    public String getString(int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            throw new IllegalArgumentException("Column index must always be 0 for aggregation result sets");
        }
        if (rowIndex != 0) {
            throw new IllegalArgumentException("Row index must always be 0 for aggregation result sets");
        }
        return this._jsonObject.get("value").asText();
    }

    @Override
    public int getGroupKeyLength() {
        return 0;
    }

    @Override
    public String getGroupKeyColumnName(int groupKeyColumnIndex) {
        throw new AssertionError((Object)"No group key column name for aggregation results");
    }

    @Override
    public String getGroupKeyString(int rowIndex, int groupKeyColumnIndex) {
        throw new AssertionError((Object)"No grouping key for queries without a group by clause");
    }

    public String toString() {
        int numColumns = this.getColumnCount();
        TextTable table = new TextTable();
        String[] columnNames = new String[numColumns];
        for (int c = 0; c < this.getColumnCount(); ++c) {
            columnNames[c] = this.getColumnName(c);
        }
        table.addHeader(columnNames);
        int numRows = this.getRowCount();
        for (int r = 0; r < numRows; ++r) {
            String[] columnValues = new String[numColumns];
            for (int c = 0; c < this.getColumnCount(); ++c) {
                columnValues[c] = this.getString(r, c);
            }
            table.addRow(columnValues);
        }
        return table.toString();
    }
}

