/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.ExecutionStats;

public class BrokerResponse {
    private String _requestId;
    private String _brokerId;
    private JsonNode _aggregationResults;
    private JsonNode _selectionResults;
    private JsonNode _resultTable;
    private JsonNode _exceptions;
    private ExecutionStats _executionStats;

    private BrokerResponse() {
    }

    private BrokerResponse(JsonNode brokerResponse) {
        this._requestId = brokerResponse.get("requestId") != null ? brokerResponse.get("requestId").asText() : "unknown";
        this._brokerId = brokerResponse.get("brokerId") != null ? brokerResponse.get("brokerId").asText() : "unknown";
        this._aggregationResults = brokerResponse.get("aggregationResults");
        this._exceptions = brokerResponse.get("exceptions");
        this._selectionResults = brokerResponse.get("selectionResults");
        this._resultTable = brokerResponse.get("resultTable");
        this._executionStats = ExecutionStats.fromJson(brokerResponse);
    }

    public boolean hasExceptions() {
        return this._exceptions != null && !this._exceptions.isEmpty();
    }

    public JsonNode getExceptions() {
        return this._exceptions;
    }

    public JsonNode getAggregationResults() {
        return this._aggregationResults;
    }

    public JsonNode getSelectionResults() {
        return this._selectionResults;
    }

    public JsonNode getResultTable() {
        return this._resultTable;
    }

    public int getAggregationResultsSize() {
        if (this._aggregationResults == null) {
            return 0;
        }
        return this._aggregationResults.size();
    }

    public ExecutionStats getExecutionStats() {
        return this._executionStats;
    }

    public static BrokerResponse fromJson(JsonNode json) {
        return new BrokerResponse(json);
    }

    public static BrokerResponse empty() {
        return new BrokerResponse();
    }

    public String getRequestId() {
        return this._requestId;
    }

    public String getBrokerId() {
        return this._brokerId;
    }
}

