/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlNode;
import org.apache.pinot.client.BrokerResponse;
import org.apache.pinot.client.BrokerSelector;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PreparedStatement;
import org.apache.pinot.client.ResultSetGroup;
import org.apache.pinot.client.SimpleBrokerSelector;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.apache.pinot.sql.parsers.SqlNodeAndOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    public static final String FAIL_ON_EXCEPTIONS = "failOnExceptions";
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final PinotClientTransport<?> _transport;
    private final BrokerSelector _brokerSelector;
    private final boolean _failOnExceptions;

    Connection(List<String> brokerList, PinotClientTransport<?> transport) {
        this(new Properties(), new SimpleBrokerSelector(brokerList), transport);
    }

    Connection(Properties properties, List<String> brokerList, PinotClientTransport<?> transport) {
        this(properties, new SimpleBrokerSelector(brokerList), transport);
        LOGGER.info("Created connection to broker list {}", brokerList);
    }

    Connection(BrokerSelector brokerSelector, PinotClientTransport<?> transport) {
        this(new Properties(), brokerSelector, transport);
    }

    Connection(Properties properties, BrokerSelector brokerSelector, PinotClientTransport<?> transport) {
        this._brokerSelector = brokerSelector;
        this._transport = transport;
        this._failOnExceptions = Boolean.parseBoolean(properties.getProperty(FAIL_ON_EXCEPTIONS, "TRUE"));
    }

    public PreparedStatement prepareStatement(String query) {
        return new PreparedStatement(this, query);
    }

    public ResultSetGroup execute(String query) {
        return this.execute(null, query);
    }

    public ResultSetGroup execute(@Nullable String tableName, String query) throws PinotClientException {
        String[] stringArray;
        if (tableName == null) {
            stringArray = Connection.resolveTableName(query);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tableName;
        }
        String[] tableNames = stringArray;
        String brokerHostPort = this._brokerSelector.selectBroker(tableNames);
        if (brokerHostPort == null) {
            throw new PinotClientException("Could not find broker to query for table(s): " + Arrays.asList(tableNames));
        }
        BrokerResponse response = this._transport.executeQuery(brokerHostPort, query);
        if (response.hasExceptions() && this._failOnExceptions) {
            throw new PinotClientException("Query had processing exceptions: \n" + response.getExceptions());
        }
        return new ResultSetGroup(response);
    }

    public CompletableFuture<ResultSetGroup> executeAsync(String query) throws PinotClientException {
        return this.executeAsync(null, query);
    }

    public CompletableFuture<ResultSetGroup> executeAsync(@Nullable String tableName, String query) throws PinotClientException {
        String[] stringArray;
        if (tableName == null) {
            stringArray = Connection.resolveTableName(query);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tableName;
        }
        String[] tableNames = stringArray;
        String brokerHostPort = this._brokerSelector.selectBroker(tableNames);
        if (brokerHostPort == null) {
            throw new PinotClientException("Could not find broker to query for statement: " + query);
        }
        return this._transport.executeQueryAsync(brokerHostPort, query).thenApply(ResultSetGroup::new);
    }

    @Nullable
    private static String[] resolveTableName(String query) {
        try {
            SqlNodeAndOptions sqlNodeAndOptions = CalciteSqlParser.compileToSqlNodeAndOptions((String)query);
            return RequestUtils.getTableNames((PinotQuery)CalciteSqlParser.compileSqlNodeToPinotQuery((SqlNode)sqlNodeAndOptions.getSqlNode())).toArray(new String[0]);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse table name from query: {}. Fallback to broker selector default.", (Object)query, (Object)e);
            return null;
        }
    }

    List<String> getBrokerList() {
        return this._brokerSelector.getBrokers();
    }

    public void close() throws PinotClientException {
        this._transport.close();
        this._brokerSelector.close();
    }

    public PinotClientTransport<?> getTransport() {
        return this._transport;
    }
}

