/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.pinot.client.ConnectionTimeouts;
import org.apache.pinot.client.JsonAsyncHttpPinotClientTransport;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PinotClientTransportFactory;
import org.apache.pinot.client.TlsProtocols;
import org.apache.pinot.client.utils.ConnectionUtils;

public class JsonAsyncHttpPinotClientTransportFactory
implements PinotClientTransportFactory {
    private static final String DEFAULT_BROKER_READ_TIMEOUT_MS = "60000";
    private static final String DEFAULT_BROKER_CONNECT_TIMEOUT_MS = "2000";
    private static final String DEFAULT_BROKER_HANDSHAKE_TIMEOUT_MS = "2000";
    private static final String DEFAULT_BROKER_TLS_V10_ENABLED = "false";
    private Map<String, String> _headers = new HashMap<String, String>();
    private String _scheme = "http";
    private SSLContext _sslContext = null;
    private boolean _tlsV10Enabled = false;
    private int _readTimeoutMs = Integer.parseInt("60000");
    private int _connectTimeoutMs = Integer.parseInt("60000");
    private int _handshakeTimeoutMs = Integer.parseInt("2000");
    private String _appId = null;
    private String _extraOptionString;
    private boolean _useMultistageEngine;

    @Override
    public PinotClientTransport buildTransport() {
        ConnectionTimeouts connectionTimeouts = ConnectionTimeouts.create(this._readTimeoutMs, this._connectTimeoutMs, this._handshakeTimeoutMs);
        TlsProtocols tlsProtocols = TlsProtocols.defaultProtocols(this._tlsV10Enabled);
        return new JsonAsyncHttpPinotClientTransport(this._headers, this._scheme, this._extraOptionString, this._useMultistageEngine, this._sslContext, connectionTimeouts, tlsProtocols, this._appId);
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this._headers = headers;
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public SSLContext getSslContext() {
        return this._sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this._sslContext = sslContext;
    }

    public JsonAsyncHttpPinotClientTransportFactory withConnectionProperties(Properties properties) {
        if (this._headers == null || this._headers.isEmpty()) {
            this._headers = ConnectionUtils.getHeadersFromProperties(properties);
        }
        if (this._scheme == null) {
            this._scheme = properties.getProperty("scheme", "http");
        }
        if (this._sslContext == null && this._scheme.contentEquals("https")) {
            this._sslContext = ConnectionUtils.getSSLContextFromProperties(properties);
        }
        this._readTimeoutMs = Integer.parseInt(properties.getProperty("brokerReadTimeoutMs", DEFAULT_BROKER_READ_TIMEOUT_MS));
        this._connectTimeoutMs = Integer.parseInt(properties.getProperty("brokerConnectTimeoutMs", "2000"));
        this._handshakeTimeoutMs = Integer.parseInt(properties.getProperty("brokerHandshakeTimeoutMs", "2000"));
        this._appId = properties.getProperty("appId");
        this._tlsV10Enabled = Boolean.parseBoolean(properties.getProperty("brokerTlsV10Enabled", DEFAULT_BROKER_TLS_V10_ENABLED)) || Boolean.parseBoolean(System.getProperties().getProperty("broker.tlsV10Enabled", DEFAULT_BROKER_TLS_V10_ENABLED));
        this._extraOptionString = properties.getProperty("queryOptions", "");
        this._useMultistageEngine = Boolean.parseBoolean(properties.getProperty("useMultistageEngine", DEFAULT_BROKER_TLS_V10_ENABLED));
        return this;
    }
}

