/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TlsProtocols {
    private final List<String> _enabledProtocols;

    private TlsProtocols(List<String> enabledProtocols) {
        this._enabledProtocols = enabledProtocols;
    }

    public List<String> getEnabledProtocols() {
        if (this._enabledProtocols != null) {
            return this._enabledProtocols;
        }
        return Collections.emptyList();
    }

    public static TlsProtocols defaultProtocols(boolean tlsV10Enabled) {
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        enabledProtocols.add("TLSv1.3");
        enabledProtocols.add("TLSv1.2");
        enabledProtocols.add("TLSv1.1");
        if (tlsV10Enabled) {
            enabledProtocols.add("TLSv1.0");
        }
        return new TlsProtocols(enabledProtocols);
    }
}

