/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

public class ConnectionTimeouts {
    private final int _readTimeoutMs;
    private final int _connectTimeoutMs;
    private final int _handshakeTimeoutMs;

    private ConnectionTimeouts(int readTimeoutMs, int connectTimeoutMs, int handshakeTimeoutMs) {
        this._readTimeoutMs = readTimeoutMs;
        this._connectTimeoutMs = connectTimeoutMs;
        this._handshakeTimeoutMs = handshakeTimeoutMs;
    }

    public static ConnectionTimeouts create(int readTimeoutMs, int connectTimeoutMs, int handshakeTimeoutMs) {
        if (readTimeoutMs < 1 || connectTimeoutMs < 1 || handshakeTimeoutMs < 1) {
            throw new IllegalArgumentException("Timeouts must be > 0");
        }
        return new ConnectionTimeouts(readTimeoutMs, connectTimeoutMs, handshakeTimeoutMs);
    }

    public int getReadTimeoutMs() {
        return this._readTimeoutMs;
    }

    public int getConnectTimeoutMs() {
        return this._connectTimeoutMs;
    }

    public int getHandshakeTimeoutMs() {
        return this._handshakeTimeoutMs;
    }
}

