/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.AbstractResultSet;
import org.apache.pinot.client.TextTable;

class GroupByResultSet
extends AbstractResultSet {
    private final JsonNode _groupByResults;
    private final JsonNode _groupByColumns;
    private final String _functionName;

    public GroupByResultSet(JsonNode jsonObject) {
        this._groupByResults = jsonObject.get("groupByResult");
        this._groupByColumns = jsonObject.get("groupByColumns");
        this._functionName = jsonObject.get("function").asText();
    }

    @Override
    public int getRowCount() {
        return this._groupByResults.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this._functionName;
    }

    @Override
    public String getString(int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            throw new IllegalArgumentException("Column index must always be 0 for aggregation result sets");
        }
        return this._groupByResults.get(rowIndex).get("value").asText();
    }

    @Override
    public int getGroupKeyLength() {
        return this._groupByColumns.size();
    }

    @Override
    public String getGroupKeyString(int rowIndex, int groupKeyColumnIndex) {
        return this._groupByResults.get(rowIndex).get("group").get(groupKeyColumnIndex).asText();
    }

    @Override
    public String getGroupKeyColumnName(int groupKeyColumnIndex) {
        return this._groupByColumns.get(groupKeyColumnIndex).asText();
    }

    public String toString() {
        int c;
        int groupKeyLength = this.getGroupKeyLength();
        int numColumns = groupKeyLength + this.getColumnCount();
        TextTable table = new TextTable();
        String[] columnNames = new String[numColumns];
        for (c = 0; c < groupKeyLength; ++c) {
            try {
                columnNames[c] = this.getGroupKeyColumnName(c);
                continue;
            }
            catch (Exception e) {
                columnNames[c] = "ERROR";
            }
        }
        for (c = 0; c < this.getColumnCount(); ++c) {
            columnNames[groupKeyLength + c] = this.getColumnName(c);
        }
        table.addHeader(columnNames);
        int numRows = this.getRowCount();
        for (int r = 0; r < numRows; ++r) {
            int c2;
            String[] columnValues = new String[numColumns];
            for (c2 = 0; c2 < groupKeyLength; ++c2) {
                try {
                    columnValues[c2] = this.getGroupKeyString(r, c2);
                    continue;
                }
                catch (Exception e) {
                    columnValues[c2] = "ERROR";
                }
            }
            for (c2 = 0; c2 < this.getColumnCount(); ++c2) {
                columnValues[groupKeyLength + c2] = this.getString(r, c2);
            }
            table.addRow(columnValues);
        }
        return table.toString();
    }
}

