/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.concurrent.CompletableFuture;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.ResultSetGroup;

public class PreparedStatement {
    private final Connection _connection;
    private final String _statement;
    private final String[] _parameters;

    PreparedStatement(Connection connection, String query) {
        this._connection = connection;
        this._statement = query;
        this._parameters = new String[this.getQuestionMarkCount(query)];
    }

    private int getQuestionMarkCount(String query) {
        int questionMarkCount = 0;
        int index = query.indexOf(63);
        while (index != -1) {
            ++questionMarkCount;
            index = query.indexOf(63, index + 1);
        }
        return questionMarkCount;
    }

    private String fillStatementWithParameters() {
        String statement = this._statement;
        for (String parameter : this._parameters) {
            statement = statement.replaceFirst("\\?", parameter);
        }
        return statement;
    }

    public ResultSetGroup execute() {
        return this._connection.execute(this.fillStatementWithParameters());
    }

    public CompletableFuture<ResultSetGroup> executeAsync() {
        return this._connection.executeAsync(this.fillStatementWithParameters());
    }

    public void setString(int parameterIndex, String value) {
        this._parameters[parameterIndex] = "'" + value.replace("'", "''") + "'";
    }

    public void setInt(int parameterIndex, int value) {
        this._parameters[parameterIndex] = String.valueOf(value);
    }

    public void setLong(int parameterIndex, long value) {
        this._parameters[parameterIndex] = String.valueOf(value);
    }

    public void setFloat(int parameterIndex, float value) {
        this._parameters[parameterIndex] = String.valueOf(value);
    }

    public void setDouble(int parameterIndex, double value) {
        this._parameters[parameterIndex] = String.valueOf(value);
    }
}

