/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BrokerSelectorUtils {
    private BrokerSelectorUtils() {
    }

    public static List<String> getTablesCommonBrokers(List<String> tableNames, Map<String, List<String>> brokerData) {
        ArrayList<List<String>> tablesBrokersList = new ArrayList<List<String>>();
        for (String name : tableNames) {
            String tableName = BrokerSelectorUtils.getTableNameWithoutSuffix(name);
            int idx = tableName.indexOf(46);
            if (brokerData.containsKey(tableName)) {
                tablesBrokersList.add(brokerData.get(tableName));
                continue;
            }
            if (idx <= 0) continue;
            tableName = tableName.substring(idx + 1);
            tablesBrokersList.add(brokerData.get(tableName));
        }
        if (tablesBrokersList.isEmpty() || tablesBrokersList.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        List commonBrokers = (List)tablesBrokersList.get(0);
        for (int i = 1; i < tablesBrokersList.size(); ++i) {
            commonBrokers.retainAll((Collection)tablesBrokersList.get(i));
        }
        return commonBrokers;
    }

    private static String getTableNameWithoutSuffix(String tableName) {
        return tableName.replace("_OFFLINE", "").replace("_REALTIME", "");
    }
}

