/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.pinot.client.PinotResultMetadata;
import org.apache.pinot.client.ResultSet;
import org.apache.pinot.client.ResultTableResultSet;
import org.apache.pinot.client.base.AbstractBaseResultSet;
import org.apache.pinot.client.utils.DateTimeUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotResultSet
extends AbstractBaseResultSet {
    public static final String NULL_STRING = "null";
    private static final Logger LOG = LoggerFactory.getLogger(PinotResultSet.class);
    private ResultSet _resultSet;
    private int _totalRows;
    private int _currentRow;
    private int _totalColumns;
    private Map<String, Integer> _columns = new HashMap<String, Integer>();
    private Map<Integer, String> _columnDataTypes = new HashMap<Integer, String>();
    private boolean _closed;
    private boolean _wasNull = false;

    public PinotResultSet(ResultSet resultSet) {
        this._resultSet = resultSet;
        this._totalRows = this._resultSet.getRowCount();
        this._totalColumns = this._resultSet.getColumnCount();
        this._currentRow = -1;
        this._closed = false;
        for (int i = 0; i < this._totalColumns; ++i) {
            this._columns.put(this._resultSet.getColumnName(i), i + 1);
            this._columnDataTypes.put(i + 1, this._resultSet.getColumnDataType(i));
        }
    }

    public PinotResultSet() {
        this._totalRows = 0;
        this._currentRow = -1;
        this._totalColumns = 0;
    }

    public static PinotResultSet empty() {
        return new PinotResultSet();
    }

    public static PinotResultSet fromJson(String jsonText) {
        try {
            JsonNode brokerResponse = JsonUtils.stringToJsonNode((String)jsonText);
            ResultTableResultSet resultSet = new ResultTableResultSet(brokerResponse.get("resultTable"));
            return new PinotResultSet((ResultSet)resultSet);
        }
        catch (Exception e) {
            LOG.error("Error encountered while creating result set from JSON", (Throwable)e);
            return PinotResultSet.empty();
        }
    }

    public static PinotResultSet fromResultTable(ResultSet resultSet) {
        try {
            return new PinotResultSet(resultSet);
        }
        catch (Exception e) {
            LOG.error("Error encountered while creating result set from Result Table", (Throwable)e);
            return PinotResultSet.empty();
        }
    }

    @Override
    protected void validateState() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Not possible to operate on closed or empty result sets");
        }
    }

    @Override
    protected void validateColumn(int columnIndex) throws SQLException {
        this.validateState();
        this._wasNull = false;
        if (columnIndex > this._totalColumns) {
            throw new SQLException("Column Index should be less than " + (this._totalColumns + 1) + ". Found " + columnIndex);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.validateState();
        if (row >= 0 && row < this._totalRows) {
            this._currentRow = row;
            return true;
        }
        if (row < 0 && Math.abs(row) <= this._totalRows) {
            this._currentRow = this._totalRows + row;
            return true;
        }
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
        this.validateState();
        this._currentRow = this._totalRows;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.validateState();
        this._currentRow = -1;
    }

    @Override
    public void close() throws SQLException {
        this._resultSet = null;
        this._totalRows = 0;
        this._currentRow = -1;
        this._columns.clear();
        this._closed = true;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this._columns.containsKey(columnLabel)) {
            return this._columns.get(columnLabel);
        }
        throw new SQLException("Column with label " + columnLabel + " not found in ResultSet");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.validateState();
        return new PinotResultMetadata(this._totalColumns, this._columns, this._columnDataTypes);
    }

    @Override
    public boolean first() throws SQLException {
        this.validateState();
        this._currentRow = 0;
        return true;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes(StandardCharsets.US_ASCII));
        return in;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            String value = this.getString(columnIndex);
            BigDecimal bigDecimal = new BigDecimal(value).setScale(scale);
            return bigDecimal;
        }
        catch (Exception e) {
            throw new SQLException("Unable to fetch BigDecimal value", e);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.validateColumn(columnIndex);
        return Boolean.parseBoolean(this._resultSet.getString(this._currentRow, columnIndex - 1));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            String value = this.getString(columnIndex);
            return Hex.decodeHex((char[])value.toCharArray());
        }
        catch (Exception e) {
            throw new SQLException(String.format("Unable to fetch value for column %d", columnIndex), e);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        InputStream in = this.getUnicodeStream(columnIndex);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return reader;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            String value = this.getString(columnIndex);
            return DateTimeUtils.getDateFromString(value, cal);
        }
        catch (Exception e) {
            throw new SQLException("Unable to fetch date", e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.validateColumn(columnIndex);
        return this._resultSet.getDouble(this._currentRow, columnIndex - 1);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.validateColumn(columnIndex);
        return this._resultSet.getFloat(this._currentRow, columnIndex - 1);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.validateColumn(columnIndex);
        return this._resultSet.getInt(this._currentRow, columnIndex - 1);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.validateColumn(columnIndex);
        return this._resultSet.getLong(this._currentRow, columnIndex - 1);
    }

    @Override
    public int getRow() throws SQLException {
        this.validateState();
        return this._currentRow;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Integer value = this.getInt(columnIndex);
        return value.shortValue();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.validateColumn(columnIndex);
        String val = this._resultSet.getString(this._currentRow, columnIndex - 1);
        if (this.checkIsNull(val)) {
            return null;
        }
        return val;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        String dataType = this._columnDataTypes.getOrDefault(columnIndex, "");
        if (dataType.isEmpty()) {
            throw new SQLDataException("Data type not supported for " + dataType);
        }
        switch (dataType) {
            case "STRING": {
                return this.getString(columnIndex);
            }
            case "INT": {
                return this.getInt(columnIndex);
            }
            case "LONG": {
                return this.getLong(columnIndex);
            }
            case "FLOAT": {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case "DOUBLE": {
                return this.getDouble(columnIndex);
            }
            case "BOOLEAN": {
                return this.getBoolean(columnIndex);
            }
            case "BYTES": {
                return this.getBytes(columnIndex);
            }
        }
        throw new SQLDataException("Data type not supported for " + dataType);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Object value = this.getObject(columnIndex);
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new SQLDataException("Data type conversion is not supported from :" + value.getClass() + " to: " + type);
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return super.getObject(columnLabel, type);
    }

    private boolean checkIsNull(String val) {
        if (val == null || val.toLowerCase().contentEquals(NULL_STRING)) {
            this._wasNull = true;
            return true;
        }
        return false;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            String value = this.getString(columnIndex);
            return DateTimeUtils.getTimeFromString(value, cal);
        }
        catch (Exception e) {
            throw new SQLException("Unable to fetch date", e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            String value = this.getString(columnIndex);
            return DateTimeUtils.getTimestampFromString(value, cal);
        }
        catch (Exception e) {
            throw new SQLException("Unable to fetch date", e);
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            URL url = new URL(this.getString(columnIndex));
            return url;
        }
        catch (Exception e) {
            throw new SQLException("Unable to fetch URL", e);
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
        return in;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.validateState();
        return this._currentRow >= this._totalRows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.validateState();
        return this._currentRow < 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.validateState();
        return this._currentRow == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.validateState();
        return this._currentRow == this._totalRows - 1;
    }

    @Override
    public boolean last() throws SQLException {
        this.validateState();
        this._currentRow = this._totalRows - 1;
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        this.validateState();
        ++this._currentRow;
        boolean hasNext = this._currentRow < this._totalRows;
        return hasNext;
    }

    @Override
    public boolean previous() throws SQLException {
        this.validateState();
        if (!this.isBeforeFirst()) {
            --this._currentRow;
            return true;
        }
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.validateState();
        int nextRow = this._currentRow + rows;
        if (nextRow >= 0 && nextRow < this._totalRows) {
            this._currentRow = nextRow;
            return true;
        }
        return false;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }
}

