/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.controller;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.client.ConnectionTimeouts;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.TlsProtocols;
import org.apache.pinot.client.controller.response.ControllerTenantBrokerResponse;
import org.apache.pinot.client.controller.response.SchemaResponse;
import org.apache.pinot.client.controller.response.TableResponse;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotControllerTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotControllerTransport.class);
    Map<String, String> _headers;
    private final String _scheme;
    private final AsyncHttpClient _httpClient;

    public PinotControllerTransport(Map<String, String> headers, String scheme, @Nullable SSLContext sslContext, ConnectionTimeouts connectionTimeouts, TlsProtocols tlsProtocols, @Nullable String appId) {
        this._headers = headers;
        this._scheme = scheme;
        DefaultAsyncHttpClientConfig.Builder builder = Dsl.config();
        if (sslContext != null) {
            builder.setSslContext((SslContext)new JdkSslContext(sslContext, true, ClientAuth.OPTIONAL));
        }
        builder.setReadTimeout(connectionTimeouts.getReadTimeoutMs()).setConnectTimeout(connectionTimeouts.getConnectTimeoutMs()).setHandshakeTimeout(connectionTimeouts.getHandshakeTimeoutMs()).setUserAgent(this.getUserAgentVersionFromClassPath(appId)).setEnabledProtocols(tlsProtocols.getEnabledProtocols().toArray(new String[0]));
        this._httpClient = Dsl.asyncHttpClient((AsyncHttpClientConfig)builder.build());
    }

    private String getUserAgentVersionFromClassPath(@Nullable String appId) {
        Properties userAgentProperties = new Properties();
        try {
            userAgentProperties.load(PinotControllerTransport.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to set user agent version");
        }
        String userAgentFromProperties = userAgentProperties.getProperty("ua", "unknown");
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            return appId.substring(0, Math.min(256, appId.length())) + "-" + userAgentFromProperties;
        }
        return userAgentFromProperties;
    }

    public TableResponse getAllTables(String controllerAddress) {
        try {
            String url = this._scheme + "://" + controllerAddress + "/tables";
            BoundRequestBuilder requestBuilder = this._httpClient.prepareGet(url);
            if (this._headers != null) {
                this._headers.forEach((k, v) -> requestBuilder.addHeader((CharSequence)k, v));
            }
            ListenableFuture response = ((BoundRequestBuilder)requestBuilder.addHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).execute();
            TableResponse.TableResponseFuture tableResponseFuture = new TableResponse.TableResponseFuture((Future<Response>)response, url);
            return (TableResponse)tableResponseFuture.get();
        }
        catch (ExecutionException e) {
            throw new PinotClientException((Throwable)e);
        }
    }

    public SchemaResponse getTableSchema(String table, String controllerAddress) {
        try {
            String url = this._scheme + "://" + controllerAddress + "/tables/" + table + "/schema";
            BoundRequestBuilder requestBuilder = this._httpClient.prepareGet(url);
            if (this._headers != null) {
                this._headers.forEach((k, v) -> requestBuilder.addHeader((CharSequence)k, v));
            }
            ListenableFuture response = ((BoundRequestBuilder)requestBuilder.addHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).execute();
            SchemaResponse.SchemaResponseFuture schemaResponseFuture = new SchemaResponse.SchemaResponseFuture((Future<Response>)response, url);
            return (SchemaResponse)schemaResponseFuture.get();
        }
        catch (ExecutionException e) {
            throw new PinotClientException((Throwable)e);
        }
    }

    public ControllerTenantBrokerResponse getBrokersFromController(String controllerAddress, String tenant) {
        try {
            String url = this._scheme + "://" + controllerAddress + "/v2/brokers/tenants/" + tenant;
            BoundRequestBuilder requestBuilder = this._httpClient.prepareGet(url);
            if (this._headers != null) {
                this._headers.forEach((k, v) -> requestBuilder.addHeader((CharSequence)k, v));
            }
            ListenableFuture response = ((BoundRequestBuilder)requestBuilder.addHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).execute();
            ControllerTenantBrokerResponse.ControllerTenantBrokerResponseFuture controllerTableBrokerResponseFuture = new ControllerTenantBrokerResponse.ControllerTenantBrokerResponseFuture((Future<Response>)response, url);
            return (ControllerTenantBrokerResponse)controllerTableBrokerResponseFuture.get();
        }
        catch (ExecutionException e) {
            throw new PinotClientException((Throwable)e);
        }
    }

    public void close() throws PinotClientException {
        if (this._httpClient.isClosed()) {
            throw new PinotClientException("Connection is already closed!");
        }
        try {
            this._httpClient.close();
        }
        catch (IOException exception) {
            throw new PinotClientException("Error while closing connection!");
        }
    }
}

