/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.controller.response;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.client.PinotClientException;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ControllerResponseFuture<T>
implements Future<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerResponseFuture.class);
    private final Future<Response> _response;
    private final String _url;

    public ControllerResponseFuture(Future<Response> response, String url) {
        this._response = response;
        this._url = url;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this._response.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this._response.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this._response.isDone();
    }

    @Override
    public T get() throws ExecutionException {
        return this.get(1000L, TimeUnit.DAYS);
    }

    @Override
    public abstract T get(long var1, TimeUnit var3) throws ExecutionException;

    public String getStringResponse(long timeout, TimeUnit unit) throws ExecutionException {
        try {
            LOGGER.debug("Sending request to {}", (Object)this._url);
            Response httpResponse = this._response.get(timeout, unit);
            LOGGER.debug("Completed request, HTTP status is {}", (Object)httpResponse.getStatusCode());
            if (httpResponse.getStatusCode() != 200) {
                throw new PinotClientException("Pinot returned HTTP status " + httpResponse.getStatusCode() + ", expected 200");
            }
            String responseBody = httpResponse.getResponseBody(StandardCharsets.UTF_8);
            return responseBody;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }
}

