/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.controller.response;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.client.controller.response.ControllerResponseFuture;
import org.apache.pinot.spi.utils.JsonUtils;
import org.asynchttpclient.Response;

public class ControllerTenantBrokerResponse {
    private JsonNode _brokers;

    private ControllerTenantBrokerResponse() {
    }

    private ControllerTenantBrokerResponse(JsonNode controllerTenantBrokerResponse) {
        this._brokers = controllerTenantBrokerResponse;
    }

    public static ControllerTenantBrokerResponse fromJson(JsonNode controllerTenantBrokerResponse) {
        return new ControllerTenantBrokerResponse(controllerTenantBrokerResponse);
    }

    public static ControllerTenantBrokerResponse empty() {
        return new ControllerTenantBrokerResponse();
    }

    public List<String> getBrokers() {
        ArrayList<String> brokerList = new ArrayList<String>();
        for (JsonNode broker : this._brokers) {
            String hostName = broker.get("host").textValue();
            Integer port = broker.get("port").intValue();
            String brokerIP = hostName;
            if (hostName.contains("_")) {
                String[] hostNamePart = hostName.split("_");
                brokerIP = hostNamePart[hostNamePart.length - 1];
            }
            String brokerIPPort = String.format("%s:%d", brokerIP, port);
            brokerList.add(brokerIPPort);
        }
        return brokerList;
    }

    public static class ControllerTenantBrokerResponseFuture
    extends ControllerResponseFuture<ControllerTenantBrokerResponse> {
        public ControllerTenantBrokerResponseFuture(Future<Response> response, String url) {
            super(response, url);
        }

        @Override
        public ControllerTenantBrokerResponse get(long timeout, TimeUnit unit) throws ExecutionException {
            String response = this.getStringResponse(timeout, unit);
            try {
                JsonNode jsonResponse = JsonUtils.stringToJsonNode((String)response);
                ControllerTenantBrokerResponse tableResponse = ControllerTenantBrokerResponse.fromJson(jsonResponse);
                return tableResponse;
            }
            catch (IOException e) {
                new ExecutionException(e);
                return null;
            }
        }
    }
}

