/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotConnection;
import org.apache.pinot.client.PinotResultSet;
import org.apache.pinot.client.ResultSetGroup;
import org.apache.pinot.client.base.AbstractBaseStatement;
import org.apache.pinot.client.utils.DriverUtils;

public class PinotStatement
extends AbstractBaseStatement {
    private static final String LIMIT_STATEMENT = "LIMIT";
    private final PinotConnection _connection;
    private final Connection _session;
    private boolean _closed;
    private ResultSet _resultSet;
    private int _maxRows = 1000000;

    public PinotStatement(PinotConnection connection) {
        this._connection = connection;
        this._session = connection.getSession();
        this._closed = false;
        this._resultSet = null;
    }

    @Override
    public void close() throws SQLException {
        this._closed = true;
    }

    @Override
    protected void validateState() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is already closed!");
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.validateState();
        try {
            String enabledSql;
            ResultSetGroup resultSetGroup;
            if (!DriverUtils.queryContainsLimitStatement((String)sql)) {
                sql = (String)sql + " LIMIT " + this._maxRows;
            }
            if ((resultSetGroup = this._session.execute(enabledSql = DriverUtils.enableQueryOptions((String)sql, this._connection.getQueryOptions()))).getResultSetCount() == 0) {
                this._resultSet = PinotResultSet.empty();
                return this._resultSet;
            }
            this._resultSet = new PinotResultSet(resultSetGroup.getResultSet(0));
            return this._resultSet;
        }
        catch (PinotClientException e) {
            throw new SQLException(String.format("Failed to execute query : %s", sql), e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this._resultSet = this.executeQuery(sql);
        return this._resultSet != null;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._resultSet;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        this.validateState();
        return this._connection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._maxRows;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this._maxRows = rows;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this._maxRows = max;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }
}

