/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PinotConnectionMetaData;
import org.apache.pinot.client.PinotPreparedStatement;
import org.apache.pinot.client.PinotStatement;
import org.apache.pinot.client.base.AbstractBaseConnection;
import org.apache.pinot.client.controller.PinotControllerTransport;
import org.apache.pinot.client.controller.PinotControllerTransportFactory;
import org.apache.pinot.client.controller.response.ControllerTenantBrokerResponse;

public class PinotConnection
extends AbstractBaseConnection {
    protected static final String[] POSSIBLE_QUERY_OPTIONS = new String[]{"enableNullHandling", "useMultistageEngine"};
    private Connection _session;
    private boolean _closed = false;
    private String _controllerURL;
    private PinotControllerTransport _controllerTransport;
    private final Map<String, Object> _queryOptions = new HashMap<String, Object>();
    public static final String BROKER_LIST = "brokers";

    PinotConnection(String controllerURL, PinotClientTransport transport, String tenant, PinotControllerTransport controllerTransport) {
        this(new Properties(), controllerURL, transport, tenant, controllerTransport);
    }

    PinotConnection(Properties properties, String controllerURL, PinotClientTransport transport, String tenant, PinotControllerTransport controllerTransport) {
        this._controllerURL = controllerURL;
        this._controllerTransport = controllerTransport == null ? new PinotControllerTransportFactory().buildTransport() : controllerTransport;
        List<String> brokers = properties.containsKey(BROKER_LIST) ? Arrays.asList(properties.getProperty(BROKER_LIST).split(";")) : this.getBrokerList(controllerURL, tenant);
        this._session = new Connection(properties, brokers, transport);
        for (String possibleQueryOption : POSSIBLE_QUERY_OPTIONS) {
            String property = properties.getProperty(possibleQueryOption);
            if (property == null) continue;
            this._queryOptions.put(possibleQueryOption, this.parseOptionValue(property));
        }
    }

    private Object parseOptionValue(Object value) {
        if (value instanceof String) {
            Number numVal2;
            String str = (String)value;
            try {
                numVal2 = Long.valueOf(str);
                if (numVal2 != null) {
                    return numVal2;
                }
            }
            catch (NumberFormatException numVal2) {
                // empty catch block
            }
            try {
                numVal2 = Double.valueOf(str);
                if (numVal2 != null) {
                    return numVal2;
                }
            }
            catch (NumberFormatException numVal3) {
                // empty catch block
            }
            Boolean boolVal = Boolean.valueOf(str.toLowerCase());
            if (boolVal != null) {
                return boolVal;
            }
        }
        return value;
    }

    public Connection getSession() {
        return this._session;
    }

    public Map<String, Object> getQueryOptions() {
        return this._queryOptions;
    }

    private List<String> getBrokerList(String controllerURL, String tenant) {
        ControllerTenantBrokerResponse controllerTenantBrokerResponse = this._controllerTransport.getBrokersFromController(controllerURL, tenant);
        return controllerTenantBrokerResponse.getBrokers();
    }

    @Override
    protected void validateState() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is already closed!");
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this._session.close();
            this._controllerTransport.close();
        }
        this._controllerTransport = null;
        this._session = null;
        this._closed = true;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.validateState();
        return new PinotStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateState();
        return new PinotPreparedStatement(this, sql);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new PinotConnectionMetaData(this, this._controllerURL, this._controllerTransport);
    }
}

