/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pinot.client.PinotConnection;
import org.apache.pinot.client.PinotMeta;
import org.apache.pinot.client.PinotResultSet;
import org.apache.pinot.client.ResultSet;
import org.apache.pinot.client.ResultTableResultSet;
import org.apache.pinot.client.base.AbstractBaseConnectionMetaData;
import org.apache.pinot.client.controller.PinotControllerTransport;
import org.apache.pinot.client.controller.response.SchemaResponse;
import org.apache.pinot.client.controller.response.TableResponse;
import org.apache.pinot.client.utils.Constants;
import org.apache.pinot.client.utils.DriverUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotConnectionMetaData
extends AbstractBaseConnectionMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotConnectionMetaData.class);
    private final PinotConnection _connection;
    private final PinotControllerTransport _controllerTransport;
    private final String _controllerURL;

    public PinotConnectionMetaData(PinotConnection connection) {
        this(connection, null, null);
    }

    public PinotConnectionMetaData(PinotConnection connection, String controllerURL, PinotControllerTransport controllerTransport) {
        this._connection = connection;
        this._controllerURL = controllerURL;
        this._controllerTransport = controllerTransport;
    }

    @Override
    public String getURL() throws SQLException {
        return DriverUtils.getURIFromBrokers(this._connection.getSession().getBrokerList());
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "APACHE_PINOT";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "0.10";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "APACHE_PINOT_DRIVER";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "1.0";
    }

    @Override
    public int getDriverMajorVersion() {
        return Integer.parseInt("1.0".split(".")[0]);
    }

    @Override
    public int getDriverMinorVersion() {
        return Integer.parseInt("1.0".split(".")[1]);
    }

    @Override
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            PinotMeta pinotMeta = new PinotMeta();
            pinotMeta.setColumnNames(Constants.TABLE_COLUMNS);
            pinotMeta.setColumnDataTypes(Constants.TABLE_COLUMNS_DTYPES);
            TableResponse tableResponse = this._controllerTransport.getAllTables(this._controllerURL);
            if (tableResponse.getNumTables() == 0) {
                LOGGER.warn("No tables found in database");
            }
            for (String table : tableResponse.getAllTables()) {
                Object[] row = new Object[]{null, null, table, "TABLE", table, "", "", "", "", ""};
                pinotMeta.addRow(Arrays.asList(row));
            }
            JsonNode resultTable = JsonUtils.objectToJsonNode((Object)pinotMeta);
            return PinotResultSet.fromResultTable((ResultSet)new ResultTableResultSet(resultTable));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public java.sql.ResultSet getSchemas() throws SQLException {
        return PinotResultSet.empty();
    }

    @Override
    public java.sql.ResultSet getCatalogs() throws SQLException {
        return PinotResultSet.empty();
    }

    @Override
    public java.sql.ResultSet getTableTypes() throws SQLException {
        PinotMeta pinotMeta = new PinotMeta();
        pinotMeta.setColumnNames(Constants.TABLE_TYPES_COLUMNS);
        pinotMeta.setColumnDataTypes(Constants.TABLE_TYPES_COLUMNS_DTYPES);
        ArrayList<Object> row = new ArrayList<Object>();
        row.add("TABLE");
        pinotMeta.addRow(row);
        JsonNode resultTable = JsonUtils.objectToJsonNode((Object)pinotMeta);
        return PinotResultSet.fromResultTable((ResultSet)new ResultTableResultSet(resultTable));
    }

    @Override
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (tableNamePattern != null && tableNamePattern.equals("%")) {
            LOGGER.warn("driver does not support pattern [{}] for table name", (Object)tableNamePattern);
            return PinotResultSet.empty();
        }
        SchemaResponse schemaResponse = this._controllerTransport.getTableSchema(tableNamePattern, this._controllerURL);
        PinotMeta pinotMeta = new PinotMeta();
        pinotMeta.setColumnNames(Constants.TABLE_SCHEMA_COLUMNS);
        pinotMeta.setColumnDataTypes(Constants.TABLE_SCHEMA_COLUMNS_DTYPES);
        int ordinalPosition = 1;
        if (schemaResponse.getDimensions() != null) {
            for (JsonNode columns : schemaResponse.getDimensions()) {
                this.appendColumnMeta(pinotMeta, tableNamePattern, ordinalPosition, columns);
                ++ordinalPosition;
            }
        }
        if (schemaResponse.getMetrics() != null) {
            for (JsonNode columns : schemaResponse.getMetrics()) {
                this.appendColumnMeta(pinotMeta, tableNamePattern, ordinalPosition, columns);
                ++ordinalPosition;
            }
        }
        if (schemaResponse.getDateTimeFieldSpecs() != null) {
            for (JsonNode columns : schemaResponse.getDateTimeFieldSpecs()) {
                this.appendColumnMeta(pinotMeta, tableNamePattern, ordinalPosition, columns);
                ++ordinalPosition;
            }
        }
        JsonNode resultTable = JsonUtils.objectToJsonNode((Object)pinotMeta);
        return PinotResultSet.fromResultTable((ResultSet)new ResultTableResultSet(resultTable));
    }

    private void appendColumnMeta(PinotMeta pinotMeta, String tableName, int ordinalPosition, JsonNode columns) {
        String columnName = columns.get("name").textValue();
        String columnDataType = columns.get("dataType").textValue();
        Integer columnsSQLDataType = DriverUtils.getSQLDataType(columnDataType);
        Object[] row = new Object[]{null, null, tableName, columnName, columnsSQLDataType, columnDataType, -1, -1, -1, -1, 1, null, null, -1, -1, -1, ordinalPosition, "NO", null, null, null, -1, "NO", "NO"};
        pinotMeta.addRow(Arrays.asList(row));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._connection;
    }
}

