/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.client.JsonAsyncHttpPinotClientTransportFactory;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PinotConnection;
import org.apache.pinot.client.controller.PinotControllerTransport;
import org.apache.pinot.client.controller.PinotControllerTransportFactory;
import org.apache.pinot.client.utils.DriverUtils;
import org.apache.pinot.common.utils.TlsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotDriver
implements Driver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotDriver.class);
    private static final String URI_SCHEME = "pinot";
    public static final String INFO_TENANT = "tenant";
    public static final String DEFAULT_TENANT = "DefaultTenant";
    public static final String INFO_SCHEME = "scheme";
    public static final String INFO_HEADERS = "headers";
    private SSLContext _sslContext = null;

    public PinotDriver() {
    }

    @VisibleForTesting
    public PinotDriver(SSLContext sslContext) {
        this._sslContext = sslContext;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            LOGGER.info("Initiating connection to database for url: " + url);
            Map<String, String> urlParams = DriverUtils.getURLParams(url);
            info.putAll(urlParams);
            JsonAsyncHttpPinotClientTransportFactory factory = new JsonAsyncHttpPinotClientTransportFactory();
            PinotControllerTransportFactory pinotControllerTransportFactory = new PinotControllerTransportFactory();
            if (info.containsKey(INFO_SCHEME)) {
                factory.setScheme(info.getProperty(INFO_SCHEME));
                pinotControllerTransportFactory.setScheme(info.getProperty(INFO_SCHEME));
                if (info.getProperty(INFO_SCHEME).contentEquals("https")) {
                    if (this._sslContext == null) {
                        factory.setSslContext(DriverUtils.getSSLContextFromJDBCProps(info));
                        pinotControllerTransportFactory.setSslContext(TlsUtils.getSslContext());
                    } else {
                        factory.setSslContext(this._sslContext);
                        pinotControllerTransportFactory.setSslContext(this._sslContext);
                    }
                }
            }
            Map<String, String> headers = this.getHeadersFromProperties(info);
            DriverUtils.handleAuth(info, headers);
            if (!headers.isEmpty()) {
                factory.setHeaders(headers);
                pinotControllerTransportFactory.setHeaders(headers);
            }
            PinotClientTransport pinotClientTransport = factory.withConnectionProperties(info).buildTransport();
            PinotControllerTransport pinotControllerTransport = pinotControllerTransportFactory.withConnectionProperties(info).buildTransport();
            String controllerUrl = DriverUtils.getControllerFromURL(url);
            String tenant = info.getProperty(INFO_TENANT, DEFAULT_TENANT);
            return new PinotConnection(info, controllerUrl, pinotClientTransport, tenant, pinotControllerTransport);
        }
        catch (Exception e) {
            throw new SQLException(String.format("Failed to connect to url : %s", url), e);
        }
    }

    private Map<String, String> getHeadersFromProperties(Properties info) {
        return info.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith("headers.")).map(entry -> Pair.of((Object)entry.getKey().toString().substring(INFO_HEADERS.length() + 1), (Object)entry.getValue().toString())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        String cleanURI = url.substring(5);
        URI uri = URI.create(cleanURI);
        return uri.getScheme().contentEquals(URI_SCHEME);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ArrayList<DriverPropertyInfo> propertyInfoList = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo tenantPropertyInfo = new DriverPropertyInfo(INFO_TENANT, null);
        tenantPropertyInfo.required = true;
        tenantPropertyInfo.description = "Name of the tenant for which to create the JDBC connection. You can only query the tables belonging to the specified tenant";
        propertyInfoList.add(tenantPropertyInfo);
        return (DriverPropertyInfo[])Iterables.toArray(propertyInfoList, DriverPropertyInfo.class);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            PinotDriver driver = new PinotDriver();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

