/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.codec.binary.Hex;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotConnection;
import org.apache.pinot.client.PinotResultSet;
import org.apache.pinot.client.PreparedStatement;
import org.apache.pinot.client.ResultSetGroup;
import org.apache.pinot.client.base.AbstractBasePreparedStatement;
import org.apache.pinot.client.utils.DateTimeUtils;
import org.apache.pinot.client.utils.DriverUtils;

public class PinotPreparedStatement
extends AbstractBasePreparedStatement {
    private static final String LIMIT_STATEMENT = "LIMIT";
    private PinotConnection _connection;
    private Connection _session;
    private ResultSetGroup _resultSetGroup;
    private PreparedStatement _preparedStatement;
    private String _query;
    private boolean _closed;
    private ResultSet _resultSet;
    private int _maxRows = Integer.MAX_VALUE;

    public PinotPreparedStatement(PinotConnection connection, String query) {
        this._connection = connection;
        this._session = connection.getSession();
        this._closed = false;
        this._query = query;
        if (!DriverUtils.queryContainsLimitStatement(this._query)) {
            this._query = this._query + " LIMIT " + this._maxRows;
        }
        this._query = DriverUtils.enableQueryOptions(this._query, this._connection.getQueryOptions());
        this._preparedStatement = new PreparedStatement(this._session, this._query);
    }

    @Override
    protected void validateState() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is already closed!");
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.validateState();
        this._preparedStatement.setString(parameterIndex - 1, "NULL");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.validateState();
        this._preparedStatement.setString(parameterIndex - 1, String.valueOf(x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.validateState();
        this._preparedStatement.setInt(parameterIndex - 1, (int)x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.validateState();
        this._preparedStatement.setInt(parameterIndex - 1, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.validateState();
        this._preparedStatement.setLong(parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.validateState();
        this._preparedStatement.setFloat(parameterIndex - 1, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.validateState();
        this._preparedStatement.setDouble(parameterIndex - 1, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.validateState();
        this._preparedStatement.setString(parameterIndex - 1, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.validateState();
        this._preparedStatement.setString(parameterIndex - 1, Hex.encodeHexString((byte[])x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this._preparedStatement.setString(parameterIndex - 1, DateTimeUtils.dateToString(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.validateState();
        this._preparedStatement.setString(parameterIndex - 1, DateTimeUtils.timeToString(x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.validateState();
        this._preparedStatement.setString(parameterIndex - 1, DateTimeUtils.timeStampToString(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.validateState();
        this._preparedStatement.setString(parameterIndex - 1, x.toString());
    }

    @Override
    public void clearParameters() throws SQLException {
        this.validateState();
        this._preparedStatement = new PreparedStatement(this._session, this._query);
    }

    @Override
    public boolean execute() throws SQLException {
        this._resultSet = this.executeQuery();
        if (this._resultSet.next()) {
            this._resultSet.beforeFirst();
            return true;
        }
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.validateState();
        try {
            this._resultSetGroup = this._session.execute(DriverUtils.enableQueryOptions(sql, this._connection.getQueryOptions()));
            if (this._resultSetGroup.getResultSetCount() == 0) {
                this._resultSet = PinotResultSet.empty();
                return this._resultSet;
            }
            this._resultSet = new PinotResultSet(this._resultSetGroup.getResultSet(0));
            return this._resultSet;
        }
        catch (PinotClientException e) {
            throw new SQLException(String.format("Failed to execute query : %s", sql), e);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.validateState();
        try {
            this._resultSetGroup = this._preparedStatement.execute();
            this._resultSet = this._resultSetGroup.getResultSetCount() == 0 ? PinotResultSet.empty() : new PinotResultSet(this._resultSetGroup.getResultSet(0));
            return this._resultSet;
        }
        catch (PinotClientException e) {
            throw new SQLException(String.format("Failed to execute query : %s", this._query), e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this._resultSet = this.executeQuery(sql);
        return this._resultSet != null;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._resultSet;
    }

    @Override
    public void close() throws SQLException {
        this._preparedStatement = null;
        this._connection = null;
        this._session = null;
        this._closed = true;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        this.validateState();
        return this._connection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._maxRows;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this._maxRows = rows;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this._maxRows = max;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }
}

