/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.pinot.client.ConnectionTimeouts;
import org.apache.pinot.client.TlsProtocols;
import org.apache.pinot.client.controller.PinotControllerTransport;

public class PinotControllerTransportFactory {
    private static final String DEFAULT_CONTROLLER_READ_TIMEOUT_MS = "60000";
    private static final String DEFAULT_CONTROLLER_CONNECT_TIMEOUT_MS = "2000";
    private static final String DEFAULT_CONTROLLER_HANDSHAKE_TIMEOUT_MS = "2000";
    private static final String DEFAULT_CONTROLLER_TLS_V10_ENABLED = "false";
    private Map<String, String> _headers = new HashMap<String, String>();
    private String _scheme = "http";
    private SSLContext _sslContext = null;
    private boolean _tlsV10Enabled = false;
    private int _readTimeoutMs = Integer.parseInt("60000");
    private int _connectTimeoutMs = Integer.parseInt("2000");
    private int _handshakeTimeoutMs = Integer.parseInt("2000");
    private String _appId = null;

    public PinotControllerTransport buildTransport() {
        ConnectionTimeouts connectionTimeouts = ConnectionTimeouts.create((int)this._readTimeoutMs, (int)this._connectTimeoutMs, (int)this._handshakeTimeoutMs);
        TlsProtocols tlsProtocols = TlsProtocols.defaultProtocols((boolean)this._tlsV10Enabled);
        return new PinotControllerTransport(this._headers, this._scheme, this._sslContext, connectionTimeouts, tlsProtocols, this._appId);
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this._headers = headers;
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public SSLContext getSslContext() {
        return this._sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this._sslContext = sslContext;
    }

    public PinotControllerTransportFactory withConnectionProperties(Properties properties) {
        this._readTimeoutMs = Integer.parseInt(properties.getProperty("controllerReadTimeoutMs", DEFAULT_CONTROLLER_READ_TIMEOUT_MS));
        this._connectTimeoutMs = Integer.parseInt(properties.getProperty("controllerConnectTimeoutMs", "2000"));
        this._handshakeTimeoutMs = Integer.parseInt(properties.getProperty("controllerHandshakeTimeoutMs", "2000"));
        this._appId = properties.getProperty("appId");
        this._tlsV10Enabled = Boolean.parseBoolean(properties.getProperty("controllerTlsV10Enabled", DEFAULT_CONTROLLER_TLS_V10_ENABLED)) || Boolean.parseBoolean(System.getProperties().getProperty("controller.tlsV10Enabled", DEFAULT_CONTROLLER_TLS_V10_ENABLED));
        return this;
    }
}

