/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.controller.response;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.client.controller.response.ControllerResponseFuture;
import org.apache.pinot.spi.utils.JsonUtils;
import org.asynchttpclient.Response;

public class SchemaResponse {
    private String _schemaName;
    private JsonNode _dimensions;
    private JsonNode _metrics;
    private JsonNode _dateTimeFieldSpecs;

    private SchemaResponse() {
    }

    private SchemaResponse(JsonNode schemaResponse) {
        this._schemaName = schemaResponse.get("schemaName").textValue();
        this._dimensions = schemaResponse.get("dimensionFieldSpecs");
        this._metrics = schemaResponse.get("metricFieldSpecs");
        this._dateTimeFieldSpecs = schemaResponse.get("dateTimeFieldSpecs");
    }

    public static SchemaResponse fromJson(JsonNode schemaResponse) {
        return new SchemaResponse(schemaResponse);
    }

    public static SchemaResponse empty() {
        return new SchemaResponse();
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public JsonNode getDimensions() {
        return this._dimensions;
    }

    public JsonNode getMetrics() {
        return this._metrics;
    }

    public JsonNode getDateTimeFieldSpecs() {
        return this._dateTimeFieldSpecs;
    }

    public static class SchemaResponseFuture
    extends ControllerResponseFuture<SchemaResponse> {
        public SchemaResponseFuture(Future<Response> response, String url) {
            super(response, url);
        }

        @Override
        public SchemaResponse get(long timeout, TimeUnit unit) throws ExecutionException {
            try {
                InputStream response = this.getStreamResponse(timeout, unit);
                JsonNode jsonResponse = JsonUtils.inputStreamToJsonNode((InputStream)response);
                return SchemaResponse.fromJson(jsonResponse);
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        }
    }
}

