/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.utils;

import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.pinot.common.auth.BasicAuthUtils;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.utils.TlsUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverUtils {
    public static final String SCHEME = "jdbc:";
    public static final String DRIVER = "pinot";
    public static final Logger LOG = LoggerFactory.getLogger(DriverUtils.class);
    private static final String LIMIT_STATEMENT_REGEX = "\\s(limit)\\s";
    public static final String PINOT_JDBC_TLS_PREFIX = "pinot.jdbc.tls";
    public static final String USER_PROPERTY = "user";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String AUTH_HEADER = "Authorization";

    private DriverUtils() {
    }

    public static SSLContext getSSLContextFromJDBCProps(Properties properties) {
        TlsConfig tlsConfig = TlsUtils.extractTlsConfig((PinotConfiguration)new PinotConfiguration((Configuration)new MapConfiguration(properties)), (String)PINOT_JDBC_TLS_PREFIX);
        TlsUtils.installDefaultSSLSocketFactory((TlsConfig)tlsConfig);
        return TlsUtils.getSslContext();
    }

    public static void handleAuth(Properties info, Map<String, String> headers) throws SQLException {
        if (info.containsKey(USER_PROPERTY) && !headers.containsKey(AUTH_HEADER)) {
            String password;
            String username = info.getProperty(USER_PROPERTY);
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{username, password = info.getProperty(PASSWORD_PROPERTY, "")})) {
                throw new SQLException("Empty username or password provided.");
            }
            String authToken = BasicAuthUtils.toBasicAuthToken((String)username, (String)password);
            headers.put(AUTH_HEADER, authToken);
        }
    }

    public static List<String> getBrokersFromURL(String url) {
        if (url.toLowerCase().startsWith(SCHEME)) {
            url = url.substring(5);
        }
        URI uri = URI.create(url);
        return DriverUtils.getBrokersFromURI(uri);
    }

    public static List<String> getBrokersFromURI(URI uri) {
        String brokerUrl = String.format("%s:%d", uri.getHost(), uri.getPort());
        List<String> brokerList = Collections.singletonList(brokerUrl);
        return brokerList;
    }

    public static String getURIFromBrokers(List<String> brokers) {
        try {
            String broker = brokers.get(0);
            String[] hostPort = broker.split(":");
            URI uri = new URI("jdbc:pinot", hostPort[0], hostPort[1]);
            return uri.toString();
        }
        catch (Exception e) {
            LOG.warn("Broker list is either empty or has incorrect format", (Throwable)e);
            return "";
        }
    }

    public static String getControllerFromURL(String url) {
        if (url.regionMatches(true, 0, SCHEME, 0, SCHEME.length())) {
            url = url.substring(5);
        }
        URI uri = URI.create(url);
        String controllerUrl = String.format("%s:%d", uri.getHost(), uri.getPort());
        return controllerUrl;
    }

    public static Map<String, String> getURLParams(String url) {
        if (url.regionMatches(true, 0, SCHEME, 0, SCHEME.length())) {
            url = url.substring(SCHEME.length());
        }
        URI uri = URI.create(url);
        List params = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (NameValuePair param : params) {
            paramsMap.put(param.getName(), param.getValue());
        }
        return paramsMap;
    }

    public static Integer getSQLDataType(String columnDataType) {
        Integer columnsSQLDataType;
        if (columnDataType == null) {
            return 12;
        }
        switch (columnDataType) {
            case "STRING": {
                columnsSQLDataType = 12;
                break;
            }
            case "INT": {
                columnsSQLDataType = 4;
                break;
            }
            case "LONG": {
                columnsSQLDataType = 4;
                break;
            }
            case "FLOAT": {
                columnsSQLDataType = 6;
                break;
            }
            case "DOUBLE": {
                columnsSQLDataType = 8;
                break;
            }
            case "BIG_DECIMAL": {
                columnsSQLDataType = 3;
                break;
            }
            case "BOOLEAN": {
                columnsSQLDataType = 16;
                break;
            }
            case "BYTES": {
                columnsSQLDataType = -2;
                break;
            }
            case "TIMESTAMP": {
                columnsSQLDataType = 93;
                break;
            }
            default: {
                columnsSQLDataType = 0;
            }
        }
        return columnsSQLDataType;
    }

    public static String getJavaClassName(String columnDataType) {
        String columnsJavaClassName;
        if (columnDataType == null) {
            return String.class.getTypeName();
        }
        switch (columnDataType) {
            case "STRING": {
                columnsJavaClassName = String.class.getTypeName();
                break;
            }
            case "INT": {
                columnsJavaClassName = Integer.class.getTypeName();
                break;
            }
            case "LONG": {
                columnsJavaClassName = Long.class.getTypeName();
                break;
            }
            case "FLOAT": {
                columnsJavaClassName = Float.class.getTypeName();
                break;
            }
            case "DOUBLE": {
                columnsJavaClassName = Double.class.getTypeName();
                break;
            }
            case "BIG_DECIMAL": {
                columnsJavaClassName = BigDecimal.class.getTypeName();
                break;
            }
            case "BOOLEAN": {
                columnsJavaClassName = Boolean.class.getTypeName();
                break;
            }
            case "BYTES": {
                columnsJavaClassName = Byte.TYPE.getTypeName();
                break;
            }
            case "TIMESTAMP": {
                columnsJavaClassName = Timestamp.class.getTypeName();
                break;
            }
            default: {
                columnsJavaClassName = String.class.getTypeName();
            }
        }
        return columnsJavaClassName;
    }

    public static boolean queryContainsLimitStatement(String query) {
        Pattern pattern = Pattern.compile(LIMIT_STATEMENT_REGEX, 2);
        Matcher matcher = pattern.matcher(query);
        return matcher.find();
    }

    public static String enableQueryOptions(String sql, Map<String, Object> options) {
        StringBuilder optionsBuilder = new StringBuilder();
        for (Map.Entry<String, Object> optionEntry : options.entrySet()) {
            if (sql.contains(optionEntry.getKey())) continue;
            optionsBuilder.append(DriverUtils.createSetQueryOptionString(optionEntry.getKey(), optionEntry.getValue()));
        }
        optionsBuilder.append(sql);
        return optionsBuilder.toString();
    }

    public static String createSetQueryOptionString(String optionKey, Object optionValue) {
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append("SET ").append(optionKey);
        if (optionValue != null) {
            optionBuilder.append('=');
            if (optionValue instanceof Boolean) {
                optionBuilder.append((Boolean)optionValue);
            } else if (optionValue instanceof Integer || optionValue instanceof Long) {
                optionBuilder.append(((Number)optionValue).longValue());
            } else if (optionValue instanceof Float || optionValue instanceof Double) {
                optionBuilder.append(((Number)optionValue).doubleValue());
            } else {
                throw new IllegalArgumentException("Option Type " + optionValue.getClass().getSimpleName() + " is not supported.");
            }
        }
        optionBuilder.append(";\n");
        return optionBuilder.toString();
    }
}

