/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import java.math.BigDecimal;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public class SumPrecisionValueAggregator
implements ValueAggregator<Object, BigDecimal> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private int _maxByteSize;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.SUMPRECISION;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public BigDecimal getInitialAggregatedValue(Object rawValue) {
        BigDecimal initialValue = SumPrecisionValueAggregator.toBigDecimal(rawValue);
        this._maxByteSize = Math.max(this._maxByteSize, BigDecimalUtils.byteSize((BigDecimal)initialValue));
        return initialValue;
    }

    @Override
    public BigDecimal applyRawValue(BigDecimal value, Object rawValue) {
        value = value.add(SumPrecisionValueAggregator.toBigDecimal(rawValue));
        this._maxByteSize = Math.max(this._maxByteSize, BigDecimalUtils.byteSize((BigDecimal)value));
        return value;
    }

    private static BigDecimal toBigDecimal(Object rawValue) {
        if (rawValue instanceof byte[]) {
            return BigDecimalUtils.deserialize((byte[])((byte[])rawValue));
        }
        if (rawValue instanceof Integer || rawValue instanceof Long) {
            return BigDecimal.valueOf(((Number)rawValue).longValue());
        }
        return new BigDecimal(rawValue.toString());
    }

    @Override
    public BigDecimal applyAggregatedValue(BigDecimal value, BigDecimal aggregatedValue) {
        value = value.add(aggregatedValue);
        this._maxByteSize = Math.max(this._maxByteSize, BigDecimalUtils.byteSize((BigDecimal)value));
        return value;
    }

    @Override
    public BigDecimal cloneAggregatedValue(BigDecimal value) {
        return value;
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(BigDecimal value) {
        return BigDecimalUtils.serialize((BigDecimal)value);
    }

    @Override
    public BigDecimal deserializeAggregatedValue(byte[] bytes) {
        return BigDecimalUtils.deserialize((byte[])bytes);
    }
}

