/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import com.github.luben.zstd.Zstd;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;

class ZstandardCompressor
implements ChunkCompressor {
    static final ZstandardCompressor INSTANCE = new ZstandardCompressor();

    private ZstandardCompressor() {
    }

    public int compress(ByteBuffer inUncompressed, ByteBuffer outCompressed) throws IOException {
        int compressedSize = Zstd.compress((ByteBuffer)outCompressed, (ByteBuffer)inUncompressed);
        outCompressed.flip();
        return compressedSize;
    }

    public int maxCompressedSize(int uncompressedSize) {
        return (int)Zstd.compressBound((long)uncompressedSize);
    }

    public ChunkCompressionType compressionType() {
        return ChunkCompressionType.ZSTANDARD;
    }
}

