/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.segment.local.io.writer.impl.BaseChunkSVForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;

@NotThreadSafe
public class VarByteChunkSVForwardIndexWriter
extends BaseChunkSVForwardIndexWriter
implements VarByteChunkWriter {
    public static final int CHUNK_HEADER_ENTRY_ROW_OFFSET_SIZE = 4;
    private final int _chunkHeaderSize;
    private int _chunkHeaderOffset = 0;
    private int _chunkDataOffSet;

    public VarByteChunkSVForwardIndexWriter(File file, ChunkCompressionType compressionType, int totalDocs, int numDocsPerChunk, int lengthOfLongestEntry, int writerVersion) throws IOException {
        super(file, compressionType, totalDocs, numDocsPerChunk, numDocsPerChunk * (4 + lengthOfLongestEntry), lengthOfLongestEntry, writerVersion, false);
        this._chunkDataOffSet = this._chunkHeaderSize = numDocsPerChunk * 4;
    }

    @Override
    public void putString(String value) {
        this.putBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void putBytes(byte[] value) {
        this._chunkBuffer.putInt(this._chunkHeaderOffset, this._chunkDataOffSet);
        this._chunkHeaderOffset += 4;
        this._chunkBuffer.position(this._chunkDataOffSet);
        this._chunkBuffer.put(value);
        this._chunkDataOffSet += value.length;
        this.writeChunkIfNecessary();
    }

    public void putStrings(String[] values) {
        this._chunkBuffer.putInt(this._chunkHeaderOffset, this._chunkDataOffSet);
        this._chunkHeaderOffset += 4;
        int headerPosition = this._chunkDataOffSet;
        int headerSize = 4 + 4 * values.length;
        int bodyPosition = headerPosition + headerSize;
        this._chunkBuffer.position(bodyPosition);
        int bodySize = 0;
        int i = 0;
        int h = headerPosition + 4;
        while (i < values.length) {
            byte[] utf8 = values[i].getBytes(StandardCharsets.UTF_8);
            this._chunkBuffer.putInt(h, utf8.length);
            this._chunkBuffer.put(utf8);
            bodySize += utf8.length;
            ++i;
            h += 4;
        }
        this._chunkDataOffSet += headerSize + bodySize;
        this._chunkBuffer.putInt(headerPosition, values.length);
        this.writeChunkIfNecessary();
    }

    public void putByteArrays(byte[][] values) {
        this._chunkBuffer.putInt(this._chunkHeaderOffset, this._chunkDataOffSet);
        this._chunkHeaderOffset += 4;
        int headerPosition = this._chunkDataOffSet;
        int headerSize = 4 + 4 * values.length;
        int bodyPosition = headerPosition + headerSize;
        this._chunkBuffer.position(bodyPosition);
        int bodySize = 0;
        int i = 0;
        int h = headerPosition + 4;
        while (i < values.length) {
            byte[] utf8 = values[i];
            this._chunkBuffer.putInt(h, utf8.length);
            this._chunkBuffer.put(utf8);
            bodySize += utf8.length;
            ++i;
            h += 4;
        }
        this._chunkDataOffSet += headerSize + bodySize;
        this._chunkBuffer.putInt(headerPosition, values.length);
        this.writeChunkIfNecessary();
    }

    private void writeChunkIfNecessary() {
        if (this._chunkHeaderOffset == this._chunkHeaderSize) {
            this.writeChunk();
        }
    }

    @Override
    protected void writeChunk() {
        for (int i = this._chunkHeaderOffset; i < this._chunkHeaderSize; i += 4) {
            this._chunkBuffer.putInt(i, 0);
        }
        super.writeChunk();
        this._chunkHeaderOffset = 0;
        this._chunkDataOffSet = this._chunkHeaderSize;
    }
}

