/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.converter;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.segment.local.realtime.converter.stats.RealtimeSegmentSegmentCreationDataSource;
import org.apache.pinot.segment.local.recordtransformer.CompositeTransformer;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class RealtimeSegmentConverter {
    private MutableSegmentImpl _realtimeSegmentImpl;
    private final String _outputPath;
    private final Schema _dataSchema;
    private final String _tableName;
    private final TableConfig _tableConfig;
    private final String _segmentName;
    private final String _sortedColumn;
    private final List<String> _invertedIndexColumns;
    private final List<String> _textIndexColumns;
    private final List<String> _fstIndexColumns;
    private final List<String> _noDictionaryColumns;
    private final List<String> _varLengthDictionaryColumns;
    private final boolean _nullHandlingEnabled;

    public RealtimeSegmentConverter(MutableSegmentImpl realtimeSegment, String outputPath, Schema schema, String tableName, TableConfig tableConfig, String segmentName, String sortedColumn, List<String> invertedIndexColumns, List<String> textIndexColumns, List<String> fstIndexColumns, List<String> noDictionaryColumns, List<String> varLengthDictionaryColumns, boolean nullHandlingEnabled) {
        this._realtimeSegmentImpl = realtimeSegment;
        this._outputPath = outputPath;
        this._invertedIndexColumns = new ArrayList<String>(invertedIndexColumns);
        if (sortedColumn != null) {
            this._invertedIndexColumns.remove(sortedColumn);
        }
        this._dataSchema = RealtimeSegmentConverter.getUpdatedSchema(schema);
        this._sortedColumn = sortedColumn;
        this._tableName = tableName;
        this._tableConfig = tableConfig;
        this._segmentName = segmentName;
        this._noDictionaryColumns = noDictionaryColumns;
        this._varLengthDictionaryColumns = varLengthDictionaryColumns;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._textIndexColumns = textIndexColumns;
        this._fstIndexColumns = fstIndexColumns;
    }

    public void build(@Nullable SegmentVersion segmentVersion, ServerMetrics serverMetrics) throws Exception {
        SegmentGeneratorConfig genConfig = new SegmentGeneratorConfig(this._tableConfig, this._dataSchema);
        genConfig.setSkipTimeValueCheck(true);
        if (this._invertedIndexColumns != null && !this._invertedIndexColumns.isEmpty()) {
            for (String string : this._invertedIndexColumns) {
                genConfig.createInvertedIndexForColumn(string);
            }
        }
        if (this._noDictionaryColumns != null) {
            genConfig.setRawIndexCreationColumns(this._noDictionaryColumns);
            HashMap<String, ChunkCompressionType> columnToCompressionType = new HashMap<String, ChunkCompressionType>();
            for (String column : this._noDictionaryColumns) {
                FieldSpec fieldSpec = this._dataSchema.getFieldSpecFor(column);
                if (!fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.METRIC)) continue;
                columnToCompressionType.put(column, ChunkCompressionType.PASS_THROUGH);
            }
            genConfig.setRawIndexCompressionType(columnToCompressionType);
        }
        if (this._varLengthDictionaryColumns != null) {
            genConfig.setVarLengthDictionaryColumns(this._varLengthDictionaryColumns);
        }
        if (segmentVersion != null) {
            genConfig.setSegmentVersion(segmentVersion);
        }
        genConfig.setTableName(this._tableName);
        genConfig.setOutDir(this._outputPath);
        genConfig.setSegmentName(this._segmentName);
        genConfig.setTextIndexCreationColumns(this._textIndexColumns);
        genConfig.setFSTIndexCreationColumns(this._fstIndexColumns);
        SegmentPartitionConfig segmentPartitionConfig = this._realtimeSegmentImpl.getSegmentPartitionConfig();
        genConfig.setSegmentPartitionConfig(segmentPartitionConfig);
        genConfig.setNullHandlingEnabled(this._nullHandlingEnabled);
        SegmentIndexCreationDriverImpl segmentIndexCreationDriverImpl = new SegmentIndexCreationDriverImpl();
        try (PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();){
            int[] sortedDocIds = this._sortedColumn != null ? this._realtimeSegmentImpl.getSortedDocIdIterationOrderWithSortedColumn(this._sortedColumn) : null;
            recordReader.init(this._realtimeSegmentImpl, sortedDocIds);
            RealtimeSegmentSegmentCreationDataSource dataSource = new RealtimeSegmentSegmentCreationDataSource(this._realtimeSegmentImpl, recordReader);
            segmentIndexCreationDriverImpl.init(genConfig, dataSource, CompositeTransformer.getPassThroughTransformer(), null);
            segmentIndexCreationDriverImpl.build();
        }
        if (segmentPartitionConfig != null) {
            Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
            for (String columnName : columnPartitionMap.keySet()) {
                int numPartitions = segmentIndexCreationDriverImpl.getSegmentStats().getColumnProfileFor(columnName).getPartitions().size();
                serverMetrics.addValueToTableGauge(this._tableName, (AbstractMetrics.Gauge)ServerGauge.REALTIME_SEGMENT_NUM_PARTITIONS, (long)numPartitions);
            }
        }
    }

    @VisibleForTesting
    public static Schema getUpdatedSchema(Schema original) {
        Schema newSchema = new Schema();
        for (String col : original.getPhysicalColumnNames()) {
            newSchema.addField(original.getFieldSpecFor(col));
        }
        return newSchema;
    }
}

