/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteSVMutableForwardIndex;
import org.apache.pinot.spi.data.FieldSpec;

public class IntOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private final FixedByteSVMutableForwardIndex _dictIdToValue;
    private volatile int _min = Integer.MAX_VALUE;
    private volatile int _max = Integer.MIN_VALUE;

    public IntOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowSize, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        super(estimatedCardinality, maxOverflowSize, memoryManager, allocationContext);
        int initialEntryCount = this.nearestPowerOf2(estimatedCardinality);
        this._dictIdToValue = new FixedByteSVMutableForwardIndex(false, FieldSpec.DataType.INT, initialEntryCount, memoryManager, allocationContext);
    }

    public int index(Object value) {
        Integer integerValue = (Integer)value;
        this.updateMinMax(integerValue);
        return this.indexValue(integerValue, null);
    }

    public int[] index(Object[] values) {
        int numValues = values.length;
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            Integer integerValue = (Integer)values[i];
            this.updateMinMax(integerValue);
            dictIds[i] = this.indexValue(integerValue, null);
        }
        return dictIds;
    }

    public int compare(int dictId1, int dictId2) {
        return Integer.compare(this.getIntValue(dictId1), this.getIntValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        if (lower.equals("*")) {
            int upperValue = Integer.parseInt(upper);
            if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    int value = this.getIntValue(dictId);
                    if (value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    int value = this.getIntValue(dictId);
                    if (value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            }
        } else if (upper.equals("*")) {
            int lowerValue = Integer.parseInt(lower);
            if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    int value = this.getIntValue(dictId);
                    if (value < lowerValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    int value = this.getIntValue(dictId);
                    if (value <= lowerValue) continue;
                    dictIds.add(dictId);
                }
            }
        } else {
            int lowerValue = Integer.parseInt(lower);
            int upperValue = Integer.parseInt(upper);
            if (includeLower && includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    int value = this.getIntValue(dictId);
                    if (value < lowerValue || value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    int value = this.getIntValue(dictId);
                    if (value < lowerValue || value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            } else if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    int value = this.getIntValue(dictId);
                    if (value <= lowerValue || value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    int value = this.getIntValue(dictId);
                    if (value <= lowerValue || value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            }
        }
        return dictIds;
    }

    public Integer getMinVal() {
        return this._min;
    }

    public Integer getMaxVal() {
        return this._max;
    }

    public int[] getSortedValues() {
        int numValues = this.length();
        int[] sortedValues = new int[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getIntValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    public int indexOf(String stringValue) {
        return this.getDictId(Integer.valueOf(stringValue), null);
    }

    public Integer get(int dictId) {
        return this.getIntValue(dictId);
    }

    public int getIntValue(int dictId) {
        return this._dictIdToValue.getInt(dictId);
    }

    public long getLongValue(int dictId) {
        return this.getIntValue(dictId);
    }

    public float getFloatValue(int dictId) {
        return this.getIntValue(dictId);
    }

    public double getDoubleValue(int dictId) {
        return this.getIntValue(dictId);
    }

    public String getStringValue(int dictId) {
        return Integer.toString(this.getIntValue(dictId));
    }

    @Override
    protected void setValue(int dictId, Object value, byte[] serializedValue) {
        this._dictIdToValue.setInt(dictId, (Integer)value);
    }

    @Override
    protected boolean equalsValueAt(int dictId, Object value, byte[] serializedValue) {
        return this.getIntValue(dictId) == ((Integer)value).intValue();
    }

    @Override
    public int getAvgValueSize() {
        return 4;
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return this.getOffHeapMemUsed() + 4L * (long)this.length();
    }

    @Override
    public void doClose() throws IOException {
        this._dictIdToValue.close();
    }

    private void updateMinMax(int value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

