/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteSVMutableForwardIndex;
import org.apache.pinot.spi.data.FieldSpec;

public class LongOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private final FixedByteSVMutableForwardIndex _dictIdToValue;
    private volatile long _min = Long.MAX_VALUE;
    private volatile long _max = Long.MIN_VALUE;

    public LongOffHeapMutableDictionary(int estimatedCardinality, int overflowSize, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        super(estimatedCardinality, overflowSize, memoryManager, allocationContext);
        int initialEntryCount = this.nearestPowerOf2(estimatedCardinality);
        this._dictIdToValue = new FixedByteSVMutableForwardIndex(false, FieldSpec.DataType.LONG, initialEntryCount, memoryManager, allocationContext);
    }

    public int index(Object value) {
        Long longValue = (Long)value;
        this.updateMinMax(longValue);
        return this.indexValue(longValue, null);
    }

    public int[] index(Object[] values) {
        int numValues = values.length;
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            Long longValue = (Long)values[i];
            this.updateMinMax(longValue);
            dictIds[i] = this.indexValue(longValue, null);
        }
        return dictIds;
    }

    public int compare(int dictId1, int dictId2) {
        return Long.compare(this.getLongValue(dictId1), this.getLongValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        if (lower.equals("*")) {
            long upperValue = Long.parseLong(upper);
            if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            }
        } else if (upper.equals("*")) {
            long lowerValue = Long.parseLong(lower);
            if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value < lowerValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value <= lowerValue) continue;
                    dictIds.add(dictId);
                }
            }
        } else {
            long lowerValue = Long.parseLong(lower);
            long upperValue = Long.parseLong(upper);
            if (includeLower && includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value < lowerValue || value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value < lowerValue || value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            } else if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value <= lowerValue || value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value <= lowerValue || value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            }
        }
        return dictIds;
    }

    public Long getMinVal() {
        return this._min;
    }

    public Long getMaxVal() {
        return this._max;
    }

    public long[] getSortedValues() {
        int numValues = this.length();
        long[] sortedValues = new long[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getLongValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.LONG;
    }

    public int indexOf(String stringValue) {
        return this.getDictId(Long.valueOf(stringValue), null);
    }

    public Long get(int dictId) {
        return this.getLongValue(dictId);
    }

    public int getIntValue(int dictId) {
        return (int)this.getLongValue(dictId);
    }

    public long getLongValue(int dictId) {
        return this._dictIdToValue.getLong(dictId);
    }

    public float getFloatValue(int dictId) {
        return this.getLongValue(dictId);
    }

    public double getDoubleValue(int dictId) {
        return this.getLongValue(dictId);
    }

    public String getStringValue(int dictId) {
        return Long.toString(this.getLongValue(dictId));
    }

    @Override
    protected void setValue(int dictId, Object value, byte[] serializedValue) {
        this._dictIdToValue.setLong(dictId, (Long)value);
    }

    @Override
    protected boolean equalsValueAt(int dictId, Object value, byte[] serializedValue) {
        return this.getLongValue(dictId) == ((Long)value).longValue();
    }

    @Override
    public int getAvgValueSize() {
        return 8;
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return this.getOffHeapMemUsed() + 8L * (long)this.length();
    }

    @Override
    public void doClose() throws IOException {
        this._dictIdToValue.close();
    }

    private void updateMinMax(long value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

