/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.geospatial;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.segment.local.utils.H3Utils;
import org.apache.pinot.segment.spi.index.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class MutableH3Index
implements H3IndexReader {
    private final H3IndexResolution _resolution;
    private final int _lowestResolution;
    private final Map<Long, ThreadSafeMutableRoaringBitmap> _bitmaps = new ConcurrentHashMap<Long, ThreadSafeMutableRoaringBitmap>();
    private int _nextDocId;

    public MutableH3Index(H3IndexResolution resolution) throws IOException {
        this._resolution = resolution;
        this._lowestResolution = resolution.getLowestResolution();
    }

    public void add(Geometry geometry) {
        Preconditions.checkState((boolean)(geometry instanceof Point), (String)"H3 index can only be applied to Point, got: %s", (Object)geometry.getGeometryType());
        Coordinate coordinate = geometry.getCoordinate();
        long h3Id = H3Utils.H3_CORE.geoToH3(coordinate.y, coordinate.x, this._lowestResolution);
        this._bitmaps.computeIfAbsent(h3Id, k -> new ThreadSafeMutableRoaringBitmap()).add(this._nextDocId++);
    }

    public MutableRoaringBitmap getDocIds(long h3Id) {
        ThreadSafeMutableRoaringBitmap bitmap = this._bitmaps.get(h3Id);
        return bitmap != null ? bitmap.getMutableRoaringBitmap() : new MutableRoaringBitmap();
    }

    public H3IndexResolution getH3IndexResolution() {
        return this._resolution;
    }

    public void close() {
    }
}

