/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class MutableJsonIndex
implements JsonIndexReader {
    private final Map<String, RoaringBitmap> _postingListMap = new HashMap<String, RoaringBitmap>();
    private final IntList _docIdMapping = new IntArrayList();
    private final ReentrantReadWriteLock.ReadLock _readLock;
    private final ReentrantReadWriteLock.WriteLock _writeLock;
    private int _nextDocId;
    private int _nextFlattenedDocId;

    public MutableJsonIndex() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String jsonString) throws IOException {
        try {
            List flattenedRecords = JsonUtils.flatten((JsonNode)JsonUtils.stringToJsonNode((String)jsonString));
            this._writeLock.lock();
            try {
                this.addFlattenedRecords(flattenedRecords);
            }
            finally {
                this._writeLock.unlock();
            }
        }
        finally {
            ++this._nextDocId;
        }
    }

    private void addFlattenedRecords(List<Map<String, String>> records) {
        int numRecords = records.size();
        Preconditions.checkState((this._nextFlattenedDocId + numRecords >= 0 ? 1 : 0) != 0, (String)"Got more than %s flattened records", (int)Integer.MAX_VALUE);
        for (int i = 0; i < numRecords; ++i) {
            this._docIdMapping.add(this._nextDocId);
        }
        for (Map<String, String> record : records) {
            for (Map.Entry<String, String> entry : record.entrySet()) {
                String key = entry.getKey();
                this._postingListMap.computeIfAbsent(key, k -> new RoaringBitmap()).add(this._nextFlattenedDocId);
                String keyValue = key + "\u0000" + entry.getValue();
                this._postingListMap.computeIfAbsent(keyValue, k -> new RoaringBitmap()).add(this._nextFlattenedDocId);
            }
            ++this._nextFlattenedDocId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableRoaringBitmap getMatchingDocIds(String filterString) {
        FilterContext filter;
        try {
            filter = RequestContextUtils.getFilter((Expression)CalciteSqlParser.compileToExpression((String)filterString));
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid json match filter: " + filterString);
        }
        this._readLock.lock();
        try {
            if (filter.getType() == FilterContext.Type.PREDICATE && this.isExclusive(filter.getPredicate().getType())) {
                RoaringBitmap matchingFlattenedDocIds = this.getMatchingFlattenedDocIds(filter.getPredicate());
                MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
                matchingFlattenedDocIds.forEach(flattenedDocId -> matchingDocIds.add(this._docIdMapping.getInt(flattenedDocId)));
                matchingDocIds.flip(0L, (long)this._nextDocId);
                MutableRoaringBitmap mutableRoaringBitmap = matchingDocIds;
                return mutableRoaringBitmap;
            }
            RoaringBitmap matchingFlattenedDocIds = this.getMatchingFlattenedDocIds(filter);
            MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
            matchingFlattenedDocIds.forEach(flattenedDocId -> matchingDocIds.add(this._docIdMapping.getInt(flattenedDocId)));
            MutableRoaringBitmap mutableRoaringBitmap = matchingDocIds;
            return mutableRoaringBitmap;
        }
        finally {
            this._readLock.unlock();
        }
    }

    private boolean isExclusive(Predicate.Type predicateType) {
        return predicateType == Predicate.Type.NOT_EQ || predicateType == Predicate.Type.NOT_IN || predicateType == Predicate.Type.IS_NULL;
    }

    private RoaringBitmap getMatchingFlattenedDocIds(FilterContext filter) {
        switch (filter.getType()) {
            case AND: {
                List children = filter.getChildren();
                int numChildren = children.size();
                RoaringBitmap matchingDocIds = this.getMatchingFlattenedDocIds((FilterContext)children.get(0));
                for (int i = 1; i < numChildren; ++i) {
                    matchingDocIds.and(this.getMatchingFlattenedDocIds((FilterContext)children.get(i)));
                }
                return matchingDocIds;
            }
            case OR: {
                List children = filter.getChildren();
                int numChildren = children.size();
                RoaringBitmap matchingDocIds = this.getMatchingFlattenedDocIds((FilterContext)children.get(0));
                for (int i = 1; i < numChildren; ++i) {
                    matchingDocIds.or(this.getMatchingFlattenedDocIds((FilterContext)children.get(i)));
                }
                return matchingDocIds;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                Preconditions.checkArgument((!this.isExclusive(predicate.getType()) ? 1 : 0) != 0, (String)"Exclusive predicate: %s cannot be nested", (Object)predicate);
                return this.getMatchingFlattenedDocIds(predicate);
            }
        }
        throw new IllegalStateException();
    }

    private RoaringBitmap getMatchingFlattenedDocIds(Predicate predicate) {
        int leftBracketIndex;
        ExpressionContext lhs = predicate.getLhs();
        Preconditions.checkArgument((lhs.getType() == ExpressionContext.Type.IDENTIFIER ? 1 : 0) != 0, (String)"Left-hand side of the predicate must be an identifier, got: %s (%s). Put double quotes around the identifier if needed.", (Object)lhs, (Object)lhs.getType());
        Object key = lhs.getIdentifier();
        key = ((String)key).charAt(0) == '$' ? ((String)key).substring(1) : "." + (String)key;
        RoaringBitmap matchingDocIds = null;
        while ((leftBracketIndex = ((String)key).indexOf(91)) >= 0) {
            int rightBracketIndex = ((String)key).indexOf(93, leftBracketIndex + 2);
            Preconditions.checkArgument((rightBracketIndex > 0 ? 1 : 0) != 0, (String)"Missing right bracket in key: %s", (Object)key);
            String leftPart = ((String)key).substring(0, leftBracketIndex);
            String arrayIndex = ((String)key).substring(leftBracketIndex + 1, rightBracketIndex);
            String rightPart = ((String)key).substring(rightBracketIndex + 1);
            if (!arrayIndex.equals("*")) {
                String searchKey = leftPart + ".$index\u0000" + arrayIndex;
                RoaringBitmap docIds = this._postingListMap.get(searchKey);
                if (docIds != null) {
                    if (matchingDocIds == null) {
                        matchingDocIds = docIds.clone();
                    } else {
                        matchingDocIds.and(docIds);
                    }
                } else {
                    return new RoaringBitmap();
                }
            }
            key = leftPart + "." + rightPart;
        }
        Predicate.Type predicateType = predicate.getType();
        if (predicateType == Predicate.Type.EQ || predicateType == Predicate.Type.NOT_EQ) {
            String value = predicateType == Predicate.Type.EQ ? ((EqPredicate)predicate).getValue() : ((NotEqPredicate)predicate).getValue();
            String keyValuePair = (String)key + "\u0000" + value;
            RoaringBitmap matchingDocIdsForKeyValuePair = this._postingListMap.get(keyValuePair);
            if (matchingDocIdsForKeyValuePair != null) {
                if (matchingDocIds == null) {
                    return matchingDocIdsForKeyValuePair.clone();
                }
                matchingDocIds.and(matchingDocIdsForKeyValuePair);
                return matchingDocIds;
            }
            return new RoaringBitmap();
        }
        if (predicateType == Predicate.Type.IN || predicateType == Predicate.Type.NOT_IN) {
            List values = predicateType == Predicate.Type.IN ? ((InPredicate)predicate).getValues() : ((NotInPredicate)predicate).getValues();
            RoaringBitmap matchingDocIdsForKeyValuePairs = new RoaringBitmap();
            for (String value : values) {
                String keyValuePair = (String)key + "\u0000" + value;
                RoaringBitmap matchingDocIdsForKeyValuePair = this._postingListMap.get(keyValuePair);
                if (matchingDocIdsForKeyValuePair == null) continue;
                matchingDocIdsForKeyValuePairs.or(matchingDocIdsForKeyValuePair);
            }
            if (matchingDocIds == null) {
                return matchingDocIdsForKeyValuePairs;
            }
            matchingDocIds.and(matchingDocIdsForKeyValuePairs);
            return matchingDocIds;
        }
        if (predicateType == Predicate.Type.IS_NOT_NULL || predicateType == Predicate.Type.IS_NULL) {
            RoaringBitmap matchingDocIdsForKey = this._postingListMap.get(key);
            if (matchingDocIdsForKey != null) {
                if (matchingDocIds == null) {
                    return matchingDocIdsForKey.clone();
                }
                matchingDocIds.and(matchingDocIdsForKey);
                return matchingDocIds;
            }
            return new RoaringBitmap();
        }
        throw new IllegalStateException("Unsupported json_match predicate type: " + predicate);
    }

    public void close() {
    }
}

