/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class DataTypeTransformer
implements RecordTransformer {
    private final Map<String, PinotDataType> _dataTypes = new HashMap<String, PinotDataType>();

    public DataTypeTransformer(Schema schema) {
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            this._dataTypes.put(fieldSpec.getName(), PinotDataType.getPinotDataTypeForIngestion((FieldSpec)fieldSpec));
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, PinotDataType> entry : this._dataTypes.entrySet()) {
            String column = entry.getKey();
            try {
                PinotDataType source;
                Object value = record.getValue(column);
                if (value == null) continue;
                PinotDataType dest = entry.getValue();
                if ((value = DataTypeTransformer.standardize(column, value, dest.isSingleValue())) == null) {
                    record.putValue(column, null);
                    continue;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    source = PinotDataType.getMultiValueType(values[0].getClass());
                } else {
                    source = PinotDataType.getSingleValueType(value.getClass());
                }
                value = dest.convert(value, source);
                value = dest.toInternal(value);
                record.putValue(column, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while transforming data type for column: " + column, e);
            }
        }
        return record;
    }

    @Nullable
    @VisibleForTesting
    static Object standardize(String column, @Nullable Object value, boolean isSingleValue) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return DataTypeTransformer.standardizeCollection(column, (Collection)value, isSingleValue);
        }
        if (value instanceof Map) {
            return DataTypeTransformer.standardizeCollection(column, ((Map)value).values(), isSingleValue);
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            int numValues = values.length;
            if (numValues == 0) {
                return null;
            }
            if (numValues == 1) {
                return DataTypeTransformer.standardize(column, values[0], isSingleValue);
            }
            ArrayList<Object> standardizedValues = new ArrayList<Object>(numValues);
            for (Object singleValue : values) {
                Object standardizedValue = DataTypeTransformer.standardize(column, singleValue, true);
                if (standardizedValue == null) continue;
                standardizedValues.add(standardizedValue);
            }
            int numStandardizedValues = standardizedValues.size();
            if (numStandardizedValues == 0) {
                return null;
            }
            if (numStandardizedValues == 1) {
                return standardizedValues.get(0);
            }
            if (isSingleValue) {
                throw new IllegalArgumentException("Cannot read single-value from Object[]: " + Arrays.toString(values) + " for column: " + column);
            }
            return standardizedValues.toArray();
        }
        return value;
    }

    private static Object standardizeCollection(String column, Collection collection, boolean isSingleValue) {
        int numValues = collection.size();
        if (numValues == 0) {
            return null;
        }
        if (numValues == 1) {
            return DataTypeTransformer.standardize(column, collection.iterator().next(), isSingleValue);
        }
        ArrayList<Object> standardizedValues = new ArrayList<Object>(numValues);
        for (Object singleValue : collection) {
            Object standardizedValue = DataTypeTransformer.standardize(column, singleValue, true);
            if (standardizedValue == null) continue;
            standardizedValues.add(standardizedValue);
        }
        int numStandardizedValues = standardizedValues.size();
        if (numStandardizedValues == 0) {
            return null;
        }
        if (numStandardizedValues == 1) {
            return standardizedValues.get(0);
        }
        Preconditions.checkState((!isSingleValue ? 1 : 0) != 0, (String)"Cannot read single-value from Collection: %s for column: %s", (Object)collection, (Object)column);
        return standardizedValues.toArray();
    }
}

