/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class NullValueTransformer
implements RecordTransformer {
    private final Map<String, Object> _defaultNullValues = new HashMap<String, Object>();
    private final DateTimeFieldSpec _dateTimeFieldSpec;
    private final DateTimeFormatSpec _defaultTimeValueFormat;

    public NullValueTransformer(TableConfig tableConfig, Schema schema) {
        String timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn() || fieldSpec.getName().equals(timeColumnName)) continue;
            String fieldName = fieldSpec.getName();
            Object defaultNullValue = fieldSpec.getDefaultNullValue();
            if (fieldSpec.isSingleValueField()) {
                this._defaultNullValues.put(fieldName, defaultNullValue);
                continue;
            }
            this._defaultNullValues.put(fieldName, new Object[]{defaultNullValue});
        }
        if (tableConfig.getValidationConfig().isAllowNullTimeValue() && timeColumnName != null) {
            this._dateTimeFieldSpec = schema.getSpecForTimeColumn(timeColumnName);
            Preconditions.checkState((this._dateTimeFieldSpec != null ? 1 : 0) != 0, (String)"Failed to find time field: %s from schema: %s", (Object)timeColumnName, (Object)schema.getSchemaName());
            this._defaultTimeValueFormat = new DateTimeFormatSpec(this._dateTimeFieldSpec.getFormat());
        } else {
            this._dateTimeFieldSpec = null;
            this._defaultTimeValueFormat = null;
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, Object> entry : this._defaultNullValues.entrySet()) {
            String fieldName = entry.getKey();
            Object value = record.getValue(fieldName);
            if (value != null) continue;
            record.putDefaultNullValue(fieldName, entry.getValue());
        }
        if (this._defaultTimeValueFormat != null && record.getValue(this._dateTimeFieldSpec.getName()) == null) {
            String timeValueStr = this._defaultTimeValueFormat.fromMillisToFormat(System.currentTimeMillis());
            Object timeValue = this._dateTimeFieldSpec.getDataType().convert(timeValueStr);
            record.putDefaultNullValue(this._dateTimeFieldSpec.getName(), timeValue);
        }
        return record;
    }
}

