/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.segment.local.segment.creator.impl.nullvalue.NullValueVectorCreator;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.SegmentCreator;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.IndexingOverrides;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.index.creator.SegmentIndexCreationInfo;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.TimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentColumnarIndexCreator
implements SegmentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentColumnarIndexCreator.class);
    private static final int METADATA_PROPERTY_LENGTH_LIMIT = 512;
    private SegmentGeneratorConfig _config;
    private Map<String, ColumnIndexCreationInfo> _indexCreationInfoMap;
    private final IndexCreatorProvider _indexCreatorProvider = IndexingOverrides.getIndexCreatorProvider();
    private final Map<String, SegmentDictionaryCreator> _dictionaryCreatorMap = new HashMap<String, SegmentDictionaryCreator>();
    private final Map<String, ForwardIndexCreator> _forwardIndexCreatorMap = new HashMap<String, ForwardIndexCreator>();
    private final Map<String, DictionaryBasedInvertedIndexCreator> _invertedIndexCreatorMap = new HashMap<String, DictionaryBasedInvertedIndexCreator>();
    private final Map<String, TextIndexCreator> _textIndexCreatorMap = new HashMap<String, TextIndexCreator>();
    private final Map<String, TextIndexCreator> _fstIndexCreatorMap = new HashMap<String, TextIndexCreator>();
    private final Map<String, JsonIndexCreator> _jsonIndexCreatorMap = new HashMap<String, JsonIndexCreator>();
    private final Map<String, GeoSpatialIndexCreator> _h3IndexCreatorMap = new HashMap<String, GeoSpatialIndexCreator>();
    private final Map<String, NullValueVectorCreator> _nullValueVectorCreatorMap = new HashMap<String, NullValueVectorCreator>();
    private String _segmentName;
    private Schema _schema;
    private File _indexDir;
    private int _totalDocs;
    private int _docIdCounter;
    private boolean _nullHandlingEnabled;
    private Map<String, Map<String, String>> _columnProperties;

    public void init(SegmentGeneratorConfig segmentCreationSpec, SegmentIndexCreationInfo segmentIndexCreationInfo, Map<String, ColumnIndexCreationInfo> indexCreationInfoMap, Schema schema, File outDir) throws Exception {
        this._docIdCounter = 0;
        this._config = segmentCreationSpec;
        this._indexCreationInfoMap = indexCreationInfoMap;
        this._columnProperties = segmentCreationSpec.getColumnProperties();
        Preconditions.checkState((!outDir.exists() ? 1 : 0) != 0, (String)"Segment output directory: %s already exists", (Object)outDir);
        Preconditions.checkState((boolean)outDir.mkdirs(), (String)"Failed to create output directory: %s", (Object)outDir);
        this._indexDir = outDir;
        this._schema = schema;
        this._totalDocs = segmentIndexCreationInfo.getTotalDocs();
        if (this._totalDocs == 0) {
            return;
        }
        Collection fieldSpecs = schema.getAllFieldSpecs();
        HashSet<Object> invertedIndexColumns = new HashSet<Object>();
        for (Object columnName : this._config.getInvertedIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn((String)columnName), (String)"Cannot create inverted index for column: %s because it is not in schema", (Object)columnName);
            invertedIndexColumns.add(columnName);
        }
        HashSet<Object> textIndexColumns = new HashSet<Object>();
        for (Object columnName : this._config.getTextIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn((String)columnName), (String)"Cannot create text index for column: %s because it is not in schema", (Object)columnName);
            textIndexColumns.add(columnName);
        }
        HashSet<Object> fstIndexColumns = new HashSet<Object>();
        for (Object columnName : this._config.getFSTIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn((String)columnName), (String)"Cannot create FST index for column: %s because it is not in schema", (Object)columnName);
            fstIndexColumns.add(columnName);
        }
        HashSet<String> jsonIndexColumns = new HashSet<String>();
        for (String columnName : this._config.getJsonIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn(columnName), (String)"Cannot create text index for column: %s because it is not in schema", (Object)columnName);
            jsonIndexColumns.add(columnName);
        }
        Map h3IndexConfigs = this._config.getH3IndexConfigs();
        for (String columnName : h3IndexConfigs.keySet()) {
            Preconditions.checkState((boolean)schema.hasColumn(columnName), (String)"Cannot create H3 index for column: %s because it is not in schema", (Object)columnName);
        }
        for (FieldSpec fieldSpec : fieldSpecs) {
            H3IndexConfig h3IndexConfig;
            if (fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            ColumnIndexCreationInfo columnIndexCreationInfo = indexCreationInfoMap.get(columnName);
            Preconditions.checkNotNull((Object)columnIndexCreationInfo, (String)"Missing index creation info for column: %s", (Object)columnName);
            boolean dictEnabledColumn = this.createDictionaryForColumn(columnIndexCreationInfo, segmentCreationSpec, fieldSpec);
            Preconditions.checkState((dictEnabledColumn || !invertedIndexColumns.contains(columnName) ? 1 : 0) != 0, (String)"Cannot create inverted index for raw index column: %s", (Object)columnName);
            IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(this._indexDir).withCardinality(columnIndexCreationInfo.getDistinctValueCount()).withDictionary(dictEnabledColumn).withFieldSpec(fieldSpec).withTotalDocs(segmentIndexCreationInfo.getTotalDocs()).withTotalNumberOfEntries(columnIndexCreationInfo.getTotalNumberOfEntries()).withColumnIndexCreationInfo(columnIndexCreationInfo).sorted(columnIndexCreationInfo.isSorted()).onHeap(segmentCreationSpec.isOnHeap()).build();
            ChunkCompressionType chunkCompressionType = dictEnabledColumn ? null : this.getColumnCompressionType(segmentCreationSpec, fieldSpec);
            this._forwardIndexCreatorMap.put(columnName, this._indexCreatorProvider.newForwardIndexCreator(context.forForwardIndex(chunkCompressionType, segmentCreationSpec.getColumnProperties())));
            if (invertedIndexColumns.contains(columnName) && !columnIndexCreationInfo.isSorted()) {
                this._invertedIndexCreatorMap.put(columnName, this._indexCreatorProvider.newInvertedIndexCreator(context.forInvertedIndex()));
            }
            if (dictEnabledColumn) {
                SegmentDictionaryCreator dictionaryCreator = new SegmentDictionaryCreator(columnIndexCreationInfo.getSortedUniqueElementsArray(), fieldSpec, this._indexDir, columnIndexCreationInfo.isUseVarLengthDictionary());
                this._dictionaryCreatorMap.put(columnName, dictionaryCreator);
                try {
                    dictionaryCreator.build();
                }
                catch (Exception e) {
                    LOGGER.error("Error building dictionary for field: {}, cardinality: {}, number of bytes per entry: {}", new Object[]{fieldSpec.getName(), columnIndexCreationInfo.getDistinctValueCount(), dictionaryCreator.getNumBytesPerEntry()});
                    throw e;
                }
            }
            if (textIndexColumns.contains(columnName)) {
                this._textIndexCreatorMap.put(columnName, this._indexCreatorProvider.newTextIndexCreator(context.forTextIndex(true)));
            }
            if (fstIndexColumns.contains(columnName)) {
                this._fstIndexCreatorMap.put(columnName, this._indexCreatorProvider.newTextIndexCreator(context.forFSTIndex(this._config.getFSTIndexType(), (String[])columnIndexCreationInfo.getSortedUniqueElementsArray())));
            }
            if (jsonIndexColumns.contains(columnName)) {
                this._jsonIndexCreatorMap.put(columnName, this._indexCreatorProvider.newJsonIndexCreator(context.forJsonIndex()));
            }
            if ((h3IndexConfig = (H3IndexConfig)h3IndexConfigs.get(columnName)) != null) {
                this._h3IndexCreatorMap.put(columnName, this._indexCreatorProvider.newGeoSpatialIndexCreator(context.forGeospatialIndex(h3IndexConfig)));
            }
            this._nullHandlingEnabled = this._config.isNullHandlingEnabled();
            if (!this._nullHandlingEnabled) continue;
            this._nullValueVectorCreatorMap.put(columnName, new NullValueVectorCreator(this._indexDir, columnName));
        }
    }

    private boolean createDictionaryForColumn(ColumnIndexCreationInfo info, SegmentGeneratorConfig config, FieldSpec spec) {
        String column = spec.getName();
        if (config.getRawIndexCreationColumns().contains(column) || config.getRawIndexCompressionType().containsKey(column)) {
            return false;
        }
        return info.isCreateDictionary();
    }

    private ChunkCompressionType getColumnCompressionType(SegmentGeneratorConfig segmentCreationSpec, FieldSpec fieldSpec) {
        ChunkCompressionType compressionType = (ChunkCompressionType)segmentCreationSpec.getRawIndexCompressionType().get(fieldSpec.getName());
        if (compressionType == null) {
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) {
                return ChunkCompressionType.PASS_THROUGH;
            }
            return ChunkCompressionType.LZ4;
        }
        return compressionType;
    }

    public void indexRow(GenericRow row) throws IOException {
        for (Map.Entry<String, ForwardIndexCreator> entry : this._forwardIndexCreatorMap.entrySet()) {
            String columnName;
            block50: {
                int i;
                int length;
                Object[] values;
                TextIndexCreator textIndexCreator;
                SegmentDictionaryCreator dictionaryCreator;
                Object columnValueToIndex;
                ForwardIndexCreator forwardIndexCreator;
                block48: {
                    block49: {
                        GeoSpatialIndexCreator h3IndexCreator;
                        columnName = entry.getKey();
                        forwardIndexCreator = entry.getValue();
                        columnValueToIndex = row.getValue(columnName);
                        if (columnValueToIndex == null) {
                            throw new RuntimeException("Null value for column:" + columnName);
                        }
                        FieldSpec fieldSpec = this._schema.getFieldSpecFor(columnName);
                        dictionaryCreator = this._dictionaryCreatorMap.get(columnName);
                        textIndexCreator = this._textIndexCreatorMap.get(columnName);
                        if (textIndexCreator != null) {
                            if (fieldSpec.isSingleValueField()) {
                                textIndexCreator.add((String)columnValueToIndex);
                            } else {
                                values = columnValueToIndex;
                                length = values.length;
                                if (values instanceof String[]) {
                                    textIndexCreator.add((String[])values, length);
                                } else {
                                    String[] strings = new String[length];
                                    for (i = 0; i < length; ++i) {
                                        strings[i] = (String)values[i];
                                    }
                                    textIndexCreator.add(strings, length);
                                    columnValueToIndex = strings;
                                }
                            }
                        }
                        if (!fieldSpec.isSingleValueField()) break block48;
                        JsonIndexCreator jsonIndexCreator = this._jsonIndexCreatorMap.get(columnName);
                        if (jsonIndexCreator != null) {
                            jsonIndexCreator.add((String)columnValueToIndex);
                        }
                        if ((h3IndexCreator = this._h3IndexCreatorMap.get(columnName)) != null) {
                            h3IndexCreator.add(GeometrySerializer.deserialize((byte[])columnValueToIndex));
                        }
                        if (dictionaryCreator == null) break block49;
                        int dictId = dictionaryCreator.indexOfSV(columnValueToIndex);
                        forwardIndexCreator.putDictId(dictId);
                        DictionaryBasedInvertedIndexCreator invertedIndexCreator = this._invertedIndexCreatorMap.get(columnName);
                        if (invertedIndexCreator != null) {
                            invertedIndexCreator.add(dictId);
                        }
                        break block50;
                    }
                    if (textIndexCreator != null && !this.shouldStoreRawValueForTextIndex(columnName) && (columnValueToIndex = this._columnProperties.get(columnName).get("rawValueForTextIndex")) == null) {
                        columnValueToIndex = "n";
                    }
                    switch (forwardIndexCreator.getValueType()) {
                        case INT: {
                            forwardIndexCreator.putInt(((Integer)columnValueToIndex).intValue());
                            break;
                        }
                        case LONG: {
                            forwardIndexCreator.putLong(((Long)columnValueToIndex).longValue());
                            break;
                        }
                        case FLOAT: {
                            forwardIndexCreator.putFloat(((Float)columnValueToIndex).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            forwardIndexCreator.putDouble(((Double)columnValueToIndex).doubleValue());
                            break;
                        }
                        case STRING: {
                            forwardIndexCreator.putString((String)columnValueToIndex);
                            break;
                        }
                        case BYTES: {
                            forwardIndexCreator.putBytes((byte[])columnValueToIndex);
                            break;
                        }
                        case JSON: {
                            if (columnValueToIndex instanceof String) {
                                forwardIndexCreator.putString((String)columnValueToIndex);
                                break;
                            }
                            if (columnValueToIndex instanceof byte[]) {
                                forwardIndexCreator.putBytes((byte[])columnValueToIndex);
                                break;
                            }
                            break block50;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    break block50;
                }
                if (dictionaryCreator != null) {
                    int[] dictIds = dictionaryCreator.indexOfMV(columnValueToIndex);
                    forwardIndexCreator.putDictIdMV(dictIds);
                    DictionaryBasedInvertedIndexCreator invertedIndexCreator = this._invertedIndexCreatorMap.get(columnName);
                    if (invertedIndexCreator != null) {
                        invertedIndexCreator.add(dictIds, dictIds.length);
                    }
                } else {
                    if (textIndexCreator != null && !this.shouldStoreRawValueForTextIndex(columnName)) {
                        String value = this._columnProperties.get(columnName).get("rawValueForTextIndex");
                        if (value == null) {
                            value = "n";
                        }
                        if (forwardIndexCreator.getValueType().getStoredType() == FieldSpec.DataType.STRING) {
                            columnValueToIndex = new String[]{String.valueOf(value)};
                        } else if (forwardIndexCreator.getValueType().getStoredType() == FieldSpec.DataType.BYTES) {
                            columnValueToIndex = new byte[][]{String.valueOf(value).getBytes(StandardCharsets.UTF_8)};
                        } else {
                            throw new RuntimeException("Text Index is only supported for STRING and BYTES stored type");
                        }
                    }
                    values = columnValueToIndex;
                    length = values.length;
                    switch (forwardIndexCreator.getValueType()) {
                        case INT: {
                            int[] ints = new int[length];
                            for (i = 0; i < length; ++i) {
                                ints[i] = (Integer)values[i];
                            }
                            forwardIndexCreator.putIntMV(ints);
                            break;
                        }
                        case LONG: {
                            long[] longs = new long[length];
                            for (int i2 = 0; i2 < length; ++i2) {
                                longs[i2] = (Long)values[i2];
                            }
                            forwardIndexCreator.putLongMV(longs);
                            break;
                        }
                        case FLOAT: {
                            float[] floats = new float[length];
                            for (int i3 = 0; i3 < length; ++i3) {
                                floats[i3] = ((Float)values[i3]).floatValue();
                            }
                            forwardIndexCreator.putFloatMV(floats);
                            break;
                        }
                        case DOUBLE: {
                            double[] doubles = new double[length];
                            for (int i4 = 0; i4 < length; ++i4) {
                                doubles[i4] = (Double)values[i4];
                            }
                            forwardIndexCreator.putDoubleMV(doubles);
                            break;
                        }
                        case STRING: {
                            int i5;
                            if (values instanceof String[]) {
                                forwardIndexCreator.putStringMV((String[])values);
                                break;
                            }
                            String[] strings = new String[length];
                            for (i5 = 0; i5 < length; ++i5) {
                                strings[i5] = (String)values[i5];
                            }
                            forwardIndexCreator.putStringMV(strings);
                            break;
                        }
                        case BYTES: {
                            int i5;
                            if (values instanceof byte[][]) {
                                forwardIndexCreator.putBytesMV((byte[][])values);
                                break;
                            }
                            byte[][] bytesArray = new byte[length][];
                            for (i5 = 0; i5 < length; ++i5) {
                                bytesArray[i5] = (byte[])values[i5];
                            }
                            forwardIndexCreator.putBytesMV((byte[][])bytesArray);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
            if (!this._nullHandlingEnabled || !row.isNullValue(columnName)) continue;
            this._nullValueVectorCreatorMap.get(columnName).setNull(this._docIdCounter);
        }
        ++this._docIdCounter;
    }

    private boolean shouldStoreRawValueForTextIndex(String column) {
        if (this._columnProperties != null) {
            Map<String, String> props = this._columnProperties.get(column);
            return props == null || !Boolean.parseBoolean(props.get("noRawDataForTextIndex"));
        }
        return true;
    }

    public void setSegmentName(String segmentName) {
        this._segmentName = segmentName;
    }

    public void seal() throws ConfigurationException, IOException {
        for (DictionaryBasedInvertedIndexCreator invertedIndexCreator : this._invertedIndexCreatorMap.values()) {
            invertedIndexCreator.seal();
        }
        for (TextIndexCreator textIndexCreator : this._textIndexCreatorMap.values()) {
            textIndexCreator.seal();
        }
        for (TextIndexCreator fstIndexCreator : this._fstIndexCreatorMap.values()) {
            fstIndexCreator.seal();
        }
        for (JsonIndexCreator jsonIndexCreator : this._jsonIndexCreatorMap.values()) {
            jsonIndexCreator.seal();
        }
        for (GeoSpatialIndexCreator h3IndexCreator : this._h3IndexCreatorMap.values()) {
            h3IndexCreator.seal();
        }
        for (NullValueVectorCreator nullValueVectorCreator : this._nullValueVectorCreatorMap.values()) {
            nullValueVectorCreator.seal();
        }
        this.writeMetadata();
    }

    private void writeMetadata() throws ConfigurationException {
        ColumnIndexCreationInfo timeColumnIndexCreationInfo;
        PropertiesConfiguration properties = new PropertiesConfiguration(new File(this._indexDir, "metadata.properties"));
        properties.setProperty("creator.version", (Object)this._config.getCreatorVersion());
        properties.setProperty("segment.padding.character", (Object)String.valueOf('\u0000'));
        properties.setProperty("segment.name", (Object)this._segmentName);
        properties.setProperty("segment.table.name", (Object)this._config.getTableName());
        properties.setProperty("segment.dimension.column.names", (Object)this._config.getDimensions());
        properties.setProperty("segment.metric.column.names", (Object)this._config.getMetrics());
        properties.setProperty("segment.datetime.column.names", (Object)this._config.getDateTimeColumnNames());
        String timeColumnName = this._config.getTimeColumnName();
        properties.setProperty("segment.time.column.name", (Object)timeColumnName);
        properties.setProperty("segment.total.docs", (Object)String.valueOf(this._totalDocs));
        if (timeColumnName != null && (timeColumnIndexCreationInfo = this._indexCreationInfoMap.get(timeColumnName)) != null) {
            TimeUnit timeUnit;
            long endTime;
            long l;
            if (this._config.getStartTime() != null) {
                l = Long.parseLong(this._config.getStartTime());
                endTime = Long.parseLong(this._config.getEndTime());
                timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this._config.getSegmentTimeUnit())));
            } else if (this._totalDocs > 0) {
                String startTimeStr = timeColumnIndexCreationInfo.getMin().toString();
                String endTimeStr = timeColumnIndexCreationInfo.getMax().toString();
                if (this._config.getTimeColumnType() == SegmentGeneratorConfig.TimeColumnType.SIMPLE_DATE) {
                    DateTimeFormatSpec formatSpec = this._config.getDateTimeFormatSpec();
                    Preconditions.checkNotNull((Object)formatSpec, (Object)"DateTimeFormatSpec must exist for SimpleDate");
                    DateTimeFormatter dateTimeFormatter = formatSpec.getDateTimeFormatter();
                    l = dateTimeFormatter.parseMillis(startTimeStr);
                    endTime = dateTimeFormatter.parseMillis(endTimeStr);
                    timeUnit = TimeUnit.MILLISECONDS;
                } else {
                    l = Long.parseLong(startTimeStr);
                    endTime = Long.parseLong(endTimeStr);
                    timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this._config.getSegmentTimeUnit())));
                }
            } else {
                long now = System.currentTimeMillis();
                if (this._config.getTimeColumnType() == SegmentGeneratorConfig.TimeColumnType.SIMPLE_DATE) {
                    l = now;
                    endTime = now;
                    timeUnit = TimeUnit.MILLISECONDS;
                } else {
                    timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this._config.getSegmentTimeUnit())));
                    l = timeUnit.convert(now, TimeUnit.MILLISECONDS);
                    endTime = timeUnit.convert(now, TimeUnit.MILLISECONDS);
                }
            }
            if (!this._config.isSkipTimeValueCheck()) {
                Interval timeInterval = new Interval(timeUnit.toMillis(l), timeUnit.toMillis(endTime), DateTimeZone.UTC);
                Preconditions.checkState((boolean)TimeUtils.isValidTimeInterval((Interval)timeInterval), (String)"Invalid segment start/end time: %s (in millis: %s/%s) for time column: %s, must be between: %s", (Object[])new Object[]{timeInterval, timeInterval.getStartMillis(), timeInterval.getEndMillis(), timeColumnName, TimeUtils.VALID_TIME_INTERVAL});
            }
            properties.setProperty("segment.start.time", (Object)l);
            properties.setProperty("segment.end.time", (Object)endTime);
            properties.setProperty("segment.time.unit", (Object)timeUnit);
        }
        for (Map.Entry entry : this._config.getCustomProperties().entrySet()) {
            properties.setProperty((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this._indexCreationInfoMap.entrySet()) {
            String column = (String)entry.getKey();
            ColumnIndexCreationInfo columnIndexCreationInfo = (ColumnIndexCreationInfo)entry.getValue();
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(column);
            int dictionaryElementSize = dictionaryCreator != null ? dictionaryCreator.getNumBytesPerEntry() : 0;
            SegmentColumnarIndexCreator.addColumnMetadataInfo(properties, column, columnIndexCreationInfo, this._totalDocs, this._schema.getFieldSpecFor(column), this._dictionaryCreatorMap.containsKey(column), dictionaryElementSize);
        }
        properties.save();
    }

    public static void addColumnMetadataInfo(PropertiesConfiguration properties, String column, ColumnIndexCreationInfo columnIndexCreationInfo, int totalDocs, FieldSpec fieldSpec, boolean hasDictionary, int dictionaryElementSize) {
        String defaultNullValue;
        int cardinality = columnIndexCreationInfo.getDistinctValueCount();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"cardinality"), (Object)String.valueOf(cardinality));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"totalDocs"), (Object)String.valueOf(totalDocs));
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"dataType"), (Object)String.valueOf(dataType));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"bitsPerElement"), (Object)String.valueOf(PinotDataBitSet.getNumBitsPerValue(cardinality - 1)));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"lengthOfEachEntry"), (Object)String.valueOf(dictionaryElementSize));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"columnType"), (Object)String.valueOf(fieldSpec.getFieldType()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isSorted"), (Object)String.valueOf(columnIndexCreationInfo.isSorted()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasDictionary"), (Object)String.valueOf(hasDictionary));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isSingleValues"), (Object)String.valueOf(fieldSpec.isSingleValueField()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"maxNumberOfMultiValues"), (Object)String.valueOf(columnIndexCreationInfo.getMaxNumberOfMultiValueElements()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"totalNumberOfEntries"), (Object)String.valueOf(columnIndexCreationInfo.getTotalNumberOfEntries()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isAutoGenerated"), (Object)String.valueOf(columnIndexCreationInfo.isAutoGenerated()));
        PartitionFunction partitionFunction = columnIndexCreationInfo.getPartitionFunction();
        if (partitionFunction != null) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"partitionFunction"), (Object)partitionFunction.getName());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"numPartitions"), (Object)columnIndexCreationInfo.getNumPartitions());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"partitionValues"), (Object)columnIndexCreationInfo.getPartitions());
            if (columnIndexCreationInfo.getPartitionFunctionConfig() != null) {
                for (Map.Entry entry : columnIndexCreationInfo.getPartitionFunctionConfig().entrySet()) {
                    properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)String.format("%s.%s", "partitionFunctionConfig", entry.getKey())), entry.getValue());
                }
            }
        }
        if (fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.DATE_TIME)) {
            DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)fieldSpec;
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"datetimeFormat"), (Object)dateTimeFieldSpec.getFormat());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"datetimeGranularity"), (Object)dateTimeFieldSpec.getGranularity());
        }
        if (totalDocs > 0) {
            Object min = columnIndexCreationInfo.getMin();
            Object max = columnIndexCreationInfo.getMax();
            if (min != null && max != null) {
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(properties, column, min.toString(), max.toString());
            }
        }
        if (SegmentColumnarIndexCreator.isValidPropertyValue(defaultNullValue = columnIndexCreationInfo.getDefaultNullValue().toString())) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"defaultNullValue"), (Object)defaultNullValue);
        }
    }

    public static void addColumnMinMaxValueInfo(PropertiesConfiguration properties, String column, String minValue, String maxValue) {
        if (SegmentColumnarIndexCreator.isValidPropertyValue(minValue)) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"minValue"), (Object)minValue);
        }
        if (SegmentColumnarIndexCreator.isValidPropertyValue(maxValue)) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"maxValue"), (Object)maxValue);
        }
    }

    @VisibleForTesting
    static boolean isValidPropertyValue(String value) {
        int length = value.length();
        if (length == 0) {
            return true;
        }
        if (length > 512) {
            return false;
        }
        if (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(length - 1))) {
            return false;
        }
        return value.indexOf(44) == -1;
    }

    public static void removeColumnMetadataInfo(PropertiesConfiguration properties, String column) {
        properties.subset("column." + column).clear();
    }

    public void close() throws IOException {
        FileUtils.close((Iterable)Iterables.concat((Iterable[])new Iterable[]{this._dictionaryCreatorMap.values(), this._forwardIndexCreatorMap.values(), this._invertedIndexCreatorMap.values(), this._textIndexCreatorMap.values(), this._fstIndexCreatorMap.values(), this._jsonIndexCreatorMap.values(), this._h3IndexCreatorMap.values(), this._nullValueVectorCreatorMap.values()}));
    }
}

