/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkSVForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkSVForwardIndexWriterV4;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class SingleValueVarByteRawIndexCreator
implements ForwardIndexCreator {
    private static final int DEFAULT_NUM_DOCS_PER_CHUNK = 1000;
    private static final int TARGET_MAX_CHUNK_SIZE = 0x100000;
    private final VarByteChunkWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public SingleValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxLength) throws IOException {
        this(baseIndexDir, compressionType, column, totalDocs, valueType, maxLength, false, 2);
    }

    public SingleValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxLength, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        File file = new File(baseIndexDir, column + ".sv.raw.fwd");
        int numDocsPerChunk = deriveNumDocsPerChunk ? SingleValueVarByteRawIndexCreator.getNumDocsPerChunk(maxLength) : 1000;
        this._indexWriter = writerVersion < 4 ? new VarByteChunkSVForwardIndexWriter(file, compressionType, totalDocs, numDocsPerChunk, maxLength, writerVersion) : new VarByteChunkSVForwardIndexWriterV4(file, compressionType, 0x100000);
        this._valueType = valueType;
    }

    @VisibleForTesting
    public static int getNumDocsPerChunk(int lengthOfLongestEntry) {
        int overheadPerEntry = lengthOfLongestEntry + 4;
        return Math.max(0x100000 / overheadPerEntry, 1);
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public void putString(String value) {
        this._indexWriter.putString(value);
    }

    public void putBytes(byte[] value) {
        this._indexWriter.putBytes(value);
    }

    public void close() throws IOException {
        this._indexWriter.close();
    }
}

