/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;

public class DoubleColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private final DoubleSet _values = new DoubleOpenHashSet(1000);
    private double[] _sortedValues;
    private boolean _sealed = false;
    private double _prevValue = Double.NEGATIVE_INFINITY;

    public DoubleColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        if (entry instanceof Object[]) {
            Object[] values;
            for (Object obj : values = (Object[])entry) {
                double value = (Double)obj;
                this._values.add(value);
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values);
        } else {
            double value = (Double)entry;
            this.addressSorted(value);
            if (this._values.add(value)) {
                this.updatePartition(value);
            }
            ++this._totalNumberOfEntries;
        }
    }

    void addressSorted(double entry) {
        if (this._isSorted) {
            if (entry < this._prevValue) {
                this._isSorted = false;
            }
            this._prevValue = entry;
        }
    }

    @Override
    public Double getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Double getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    @Override
    public Object getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this._sortedValues = this._values.toDoubleArray();
        Arrays.sort(this._sortedValues);
        this._sealed = true;
    }
}

