/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.column.PhysicalColumnIndexContainer;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.IndexingOverrides;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoaderUtils.class);

    private LoaderUtils() {
    }

    public static ForwardIndexReader<?> getForwardIndexReader(SegmentDirectory.Reader segmentReader, ColumnMetadata columnMetadata) throws IOException {
        PinotDataBuffer dataBuffer = segmentReader.getIndexFor(columnMetadata.getColumnName(), ColumnIndexType.FORWARD_INDEX);
        return IndexingOverrides.getIndexReaderProvider().newForwardIndexReader(dataBuffer, columnMetadata);
    }

    public static BaseImmutableDictionary getDictionary(SegmentDirectory.Reader segmentReader, ColumnMetadata columnMetadata) throws IOException {
        PinotDataBuffer dataBuffer = segmentReader.getIndexFor(columnMetadata.getColumnName(), ColumnIndexType.DICTIONARY);
        return PhysicalColumnIndexContainer.loadDictionary(dataBuffer, columnMetadata, false);
    }

    public static void writeIndexToV3Format(SegmentDirectory.Writer segmentWriter, String column, File indexFile, ColumnIndexType indexType) throws IOException {
        long fileLength = indexFile.length();
        PinotDataBuffer buffer = segmentWriter.newIndexFor(column, indexType, fileLength);
        buffer.readFrom(0L, indexFile, 0L, fileLength);
        FileUtils.forceDelete((File)indexFile);
    }

    public static List<String> getStringListFromSegmentProperties(String key, PropertiesConfiguration segmentProperties) {
        ArrayList<String> stringList = new ArrayList<String>();
        List propertyList = segmentProperties.getList(key);
        if (propertyList != null) {
            for (Object value : propertyList) {
                String stringValue = value.toString();
                if (stringValue.isEmpty()) continue;
                stringList.add(stringValue);
            }
        }
        return stringList;
    }

    public static void reloadFailureRecovery(File indexDir) throws IOException {
        File segmentTempDir;
        File parentDir = indexDir.getParentFile();
        File segmentBackupDir = new File(parentDir, indexDir.getName() + ".segment.bak");
        if (segmentBackupDir.exists()) {
            LOGGER.info("Trying to recover index directory: {} from segment backup directory: {}", (Object)indexDir, (Object)segmentBackupDir);
            if (indexDir.exists()) {
                LOGGER.info("Deleting index directory: {}", (Object)indexDir);
                FileUtils.forceDelete((File)indexDir);
            }
            Preconditions.checkState((boolean)segmentBackupDir.renameTo(indexDir), (String)"Failed to rename segment backup directory: %s to index directory: %s", (Object)segmentBackupDir, (Object)indexDir);
        }
        if ((segmentTempDir = new File(parentDir, indexDir.getName() + ".segment.tmp")).exists()) {
            LOGGER.info("Trying to delete segment temporary directory: {}", (Object)segmentTempDir);
            FileUtils.forceDelete((File)segmentTempDir);
        }
    }
}

