/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.defaultcolumn;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.BaseDefaultColumnHandler;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V3DefaultColumnHandler
extends BaseDefaultColumnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(V3DefaultColumnHandler.class);

    public V3DefaultColumnHandler(File indexDir, SegmentMetadataImpl segmentMetadata, IndexLoadingConfig indexLoadingConfig, Schema schema, SegmentDirectory.Writer segmentWriter) {
        super(indexDir, segmentMetadata, indexLoadingConfig, schema, segmentWriter);
    }

    @Override
    protected boolean updateDefaultColumn(String column, BaseDefaultColumnHandler.DefaultColumnAction action) throws Exception {
        File forwardIndexFile;
        LOGGER.info("Starting default column action: {} on column: {}", (Object)action, (Object)column);
        if (action.isUpdateAction() || action.isRemoveAction()) {
            this.removeColumnIndices(column);
            if (action.isRemoveAction()) {
                return true;
            }
        }
        if (!this.createColumnV1Indices(column)) {
            return false;
        }
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        Preconditions.checkNotNull((Object)fieldSpec);
        boolean isSingleValue = fieldSpec.isSingleValueField();
        if (isSingleValue) {
            forwardIndexFile = new File(this._indexDir, column + ".sv.sorted.fwd");
            if (!forwardIndexFile.exists()) {
                forwardIndexFile = new File(this._indexDir, column + ".sv.unsorted.fwd");
            }
        } else {
            forwardIndexFile = new File(this._indexDir, column + ".mv.fwd");
        }
        LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, forwardIndexFile, ColumnIndexType.FORWARD_INDEX);
        File dictionaryFile = new File(this._indexDir, column + ".dict");
        LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, dictionaryFile, ColumnIndexType.DICTIONARY);
        return true;
    }
}

