/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.nio.ByteOrder;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapInvertedIndexReader
implements InvertedIndexReader<ImmutableRoaringBitmap> {
    public static final Logger LOGGER = LoggerFactory.getLogger(BitmapInvertedIndexReader.class);
    private final PinotDataBuffer _offsetBuffer;
    private final PinotDataBuffer _bitmapBuffer;
    private final int _firstOffset;

    public BitmapInvertedIndexReader(PinotDataBuffer dataBuffer, int numBitmaps) {
        long offsetBufferEndOffset = (long)(numBitmaps + 1) * 4L;
        this._offsetBuffer = dataBuffer.view(0L, offsetBufferEndOffset, ByteOrder.BIG_ENDIAN);
        this._bitmapBuffer = dataBuffer.view(offsetBufferEndOffset, dataBuffer.size());
        this._firstOffset = this._offsetBuffer.getInt(0);
    }

    public ImmutableRoaringBitmap getDocIds(int dictId) {
        int offset = this._offsetBuffer.getInt(dictId * 4);
        int length = this._offsetBuffer.getInt((dictId + 1) * 4) - offset;
        return new ImmutableRoaringBitmap(this._bitmapBuffer.toDirectByteBuffer((long)(offset - this._firstOffset), length));
    }

    public void close() {
    }
}

