/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.readers.BitSlicedRangeIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.LuceneFSTIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.RangeIndexReaderImpl;
import org.apache.pinot.segment.local.segment.index.readers.bloom.BloomFilterReaderFactory;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitSVForwardIndexReaderV2;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBytePower2ChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkSVForwardIndexReaderV4;
import org.apache.pinot.segment.local.segment.index.readers.geospatial.ImmutableH3IndexReader;
import org.apache.pinot.segment.local.segment.index.readers.json.ImmutableJsonIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.sorted.SortedIndexReaderImpl;
import org.apache.pinot.segment.local.segment.index.readers.text.LuceneTextIndexReader;
import org.apache.pinot.segment.local.utils.nativefst.NativeFSTIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.index.reader.SortedIndexReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.index.reader.provider.IndexReaderProvider;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexReaderProvider
implements IndexReaderProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIndexReaderProvider.class);

    public BloomFilterReader newBloomFilterReader(PinotDataBuffer dataBuffer, boolean onHeap) throws IOException {
        return BloomFilterReaderFactory.getBloomFilterReader(dataBuffer, onHeap);
    }

    public ForwardIndexReader<?> newForwardIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) throws IOException {
        if (columnMetadata.hasDictionary()) {
            if (columnMetadata.isSingleValue()) {
                if (columnMetadata.isSorted()) {
                    return new SortedIndexReaderImpl(dataBuffer, columnMetadata.getCardinality());
                }
                return new FixedBitSVForwardIndexReaderV2(dataBuffer, columnMetadata.getTotalDocs(), columnMetadata.getBitsPerElement());
            }
            return new FixedBitMVForwardIndexReader(dataBuffer, columnMetadata.getTotalDocs(), columnMetadata.getTotalNumberOfEntries(), columnMetadata.getBitsPerElement());
        }
        FieldSpec.DataType storedType = columnMetadata.getDataType().getStoredType();
        if (columnMetadata.isSingleValue()) {
            int version = dataBuffer.getInt(0);
            if (storedType.isFixedWidth()) {
                return version >= 4 ? new FixedBytePower2ChunkSVForwardIndexReader(dataBuffer, storedType) : new FixedByteChunkSVForwardIndexReader(dataBuffer, storedType);
            }
            if (version >= 4) {
                return new VarByteChunkSVForwardIndexReaderV4(dataBuffer, storedType);
            }
            return new VarByteChunkSVForwardIndexReader(dataBuffer, storedType);
        }
        return storedType.isFixedWidth() ? new FixedByteChunkMVForwardIndexReader(dataBuffer, storedType) : new VarByteChunkMVForwardIndexReader(dataBuffer, storedType);
    }

    public H3IndexReader newGeospatialIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) throws IOException {
        return new ImmutableH3IndexReader(dataBuffer);
    }

    public InvertedIndexReader<?> newInvertedIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) throws IOException {
        return new BitmapInvertedIndexReader(dataBuffer, columnMetadata.getCardinality());
    }

    public JsonIndexReader newJsonIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) throws IOException {
        return new ImmutableJsonIndexReader(dataBuffer, columnMetadata.getTotalDocs());
    }

    public RangeIndexReader<?> newRangeIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) throws IOException {
        int version = dataBuffer.getInt(0);
        if (version == 1) {
            return new RangeIndexReaderImpl(dataBuffer);
        }
        if (version == 2) {
            return new BitSlicedRangeIndexReader(dataBuffer, columnMetadata);
        }
        LOGGER.warn("Unknown range index version: {}, skip loading range index for column: {}", (Object)version, (Object)columnMetadata.getColumnName());
        return null;
    }

    public SortedIndexReader<?> newSortedIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) throws IOException {
        return new SortedIndexReaderImpl(dataBuffer, columnMetadata.getCardinality());
    }

    public TextIndexReader newFSTIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) throws IOException {
        int magicHeader = dataBuffer.getInt(0);
        if (magicHeader == 1550218081) {
            return new NativeFSTIndexReader(dataBuffer);
        }
        return new LuceneFSTIndexReader(dataBuffer);
    }

    public TextIndexReader newTextIndexReader(File file, ColumnMetadata columnMetadata, @Nullable Map<String, String> textIndexProperties) {
        return new LuceneTextIndexReader(columnMetadata.getColumnName(), file, columnMetadata.getTotalDocs(), textIndexProperties);
    }
}

