/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.io.compression.ChunkCompressorFactory;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.CleanerUtil;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarByteChunkSVForwardIndexReaderV4
implements ForwardIndexReader<ReaderContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VarByteChunkSVForwardIndexReaderV4.class);
    private static final int METADATA_ENTRY_SIZE = 8;
    private final FieldSpec.DataType _valueType;
    private final int _targetDecompressedChunkSize;
    private final ChunkDecompressor _chunkDecompressor;
    private final ChunkCompressionType _chunkCompressionType;
    private final PinotDataBuffer _metadata;
    private final PinotDataBuffer _chunks;

    public VarByteChunkSVForwardIndexReaderV4(PinotDataBuffer dataBuffer, FieldSpec.DataType valueType) {
        if (dataBuffer.getInt(0) < 4) {
            throw new IllegalStateException("version " + dataBuffer.getInt(0) + " < 4");
        }
        this._valueType = valueType;
        this._targetDecompressedChunkSize = dataBuffer.getInt(4);
        this._chunkCompressionType = ChunkCompressionType.valueOf((int)dataBuffer.getInt(8));
        this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(this._chunkCompressionType);
        int chunksOffset = dataBuffer.getInt(12);
        this._metadata = dataBuffer.view(16L, (long)chunksOffset, ByteOrder.LITTLE_ENDIAN);
        this._chunks = dataBuffer.view((long)chunksOffset, dataBuffer.size(), ByteOrder.LITTLE_ENDIAN);
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public String getString(int docId, ReaderContext context) {
        return new String(context.getValue(docId), StandardCharsets.UTF_8);
    }

    public byte[] getBytes(int docId, ReaderContext context) {
        return context.getValue(docId);
    }

    @Nullable
    public ReaderContext createContext() {
        return this._chunkCompressionType == ChunkCompressionType.PASS_THROUGH ? new UncompressedReaderContext(this._chunks, this._metadata) : new CompressedReaderContext(this._metadata, this._chunks, this._chunkDecompressor, this._chunkCompressionType, this._targetDecompressedChunkSize);
    }

    public void close() throws IOException {
    }

    private static final class CompressedReaderContext
    extends ReaderContext {
        private final ByteBuffer _decompressedBuffer;
        private final ChunkDecompressor _chunkDecompressor;
        private final ChunkCompressionType _chunkCompressionType;

        CompressedReaderContext(PinotDataBuffer metadata, PinotDataBuffer chunks, ChunkDecompressor chunkDecompressor, ChunkCompressionType chunkCompressionType, int targetChunkSize) {
            super(metadata, chunks);
            this._chunkDecompressor = chunkDecompressor;
            this._chunkCompressionType = chunkCompressionType;
            this._decompressedBuffer = ByteBuffer.allocateDirect(targetChunkSize).order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        protected byte[] processChunkAndReadFirstValue(int docId, long offset, long limit) throws IOException {
            this._decompressedBuffer.clear();
            ByteBuffer compressed = this._chunks.toDirectByteBuffer(offset, (int)(limit - offset));
            if (this._regularChunk) {
                this._chunkDecompressor.decompress(compressed, this._decompressedBuffer);
                this._numDocsInCurrentChunk = this._decompressedBuffer.getInt(0);
                return this.readSmallUncompressedValue(docId);
            }
            return this.readHugeCompressedValue(compressed, this._chunkDecompressor.decompressedLength(compressed));
        }

        @Override
        protected byte[] readSmallUncompressedValue(int docId) {
            int index = docId - this._docIdOffset;
            int offset = this._decompressedBuffer.getInt((index + 1) * 4);
            int nextOffset = index == this._numDocsInCurrentChunk - 1 ? this._decompressedBuffer.limit() : this._decompressedBuffer.getInt((index + 2) * 4);
            byte[] bytes = new byte[nextOffset - offset];
            this._decompressedBuffer.position(offset);
            this._decompressedBuffer.get(bytes);
            this._decompressedBuffer.position(0);
            return bytes;
        }

        private byte[] readHugeCompressedValue(ByteBuffer compressed, int decompressedLength) throws IOException {
            byte[] value = new byte[decompressedLength];
            if (this._chunkCompressionType == ChunkCompressionType.SNAPPY || this._chunkCompressionType == ChunkCompressionType.ZSTANDARD) {
                this.decompressViaDirectBuffer(compressed, value);
            } else {
                this._chunkDecompressor.decompress(compressed, ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN));
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decompressViaDirectBuffer(ByteBuffer compressed, byte[] target) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocateDirect(target.length).order(ByteOrder.LITTLE_ENDIAN);
            try {
                this._chunkDecompressor.decompress(compressed, buffer);
                buffer.get(target);
            }
            finally {
                if (CleanerUtil.UNMAP_SUPPORTED) {
                    CleanerUtil.getCleaner().freeBuffer(buffer);
                }
            }
        }

        public void close() throws IOException {
            CleanerUtil.cleanQuietly((ByteBuffer)this._decompressedBuffer);
        }
    }

    private static final class UncompressedReaderContext
    extends ReaderContext {
        private ByteBuffer _chunk;

        UncompressedReaderContext(PinotDataBuffer metadata, PinotDataBuffer chunks) {
            super(chunks, metadata);
        }

        @Override
        protected byte[] processChunkAndReadFirstValue(int docId, long offset, long limit) {
            this._chunk = this._chunks.toDirectByteBuffer(offset, (int)(limit - offset));
            if (!this._regularChunk) {
                return this.readHugeValue();
            }
            this._numDocsInCurrentChunk = this._chunk.getInt(0);
            return this.readSmallUncompressedValue(docId);
        }

        private byte[] readHugeValue() {
            byte[] value = new byte[this._chunk.capacity()];
            this._chunk.get(value);
            return value;
        }

        @Override
        protected byte[] readSmallUncompressedValue(int docId) {
            int index = docId - this._docIdOffset;
            int offset = this._chunk.getInt((index + 1) * 4);
            int nextOffset = index == this._numDocsInCurrentChunk - 1 ? this._chunk.limit() : this._chunk.getInt((index + 2) * 4);
            byte[] bytes = new byte[nextOffset - offset];
            this._chunk.position(offset);
            this._chunk.get(bytes);
            this._chunk.position(0);
            return bytes;
        }

        public void close() throws IOException {
        }
    }

    public static abstract class ReaderContext
    implements ForwardIndexReaderContext {
        protected final PinotDataBuffer _chunks;
        protected final PinotDataBuffer _metadata;
        protected int _docIdOffset;
        protected int _nextDocIdOffset;
        protected boolean _regularChunk;
        protected int _numDocsInCurrentChunk;

        protected ReaderContext(PinotDataBuffer metadata, PinotDataBuffer chunks) {
            this._chunks = chunks;
            this._metadata = metadata;
        }

        public byte[] getValue(int docId) {
            if (docId >= this._docIdOffset && docId < this._nextDocIdOffset) {
                return this.readSmallUncompressedValue(docId);
            }
            try {
                return this.decompressAndRead(docId);
            }
            catch (IOException e) {
                LOGGER.error("Exception caught while decompressing data chunk", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        protected long chunkIndexFor(int docId) {
            long low = 0L;
            long high = this._metadata.size() / 8L - 1L;
            while (low <= high) {
                long mid = low + high >>> 1;
                long position = mid * 8L;
                int midDocId = this._metadata.getInt(position) & Integer.MAX_VALUE;
                if (midDocId < docId) {
                    low = mid + 1L;
                    continue;
                }
                if (midDocId > docId) {
                    high = mid - 1L;
                    continue;
                }
                return position;
            }
            return (low - 1L) * 8L;
        }

        protected abstract byte[] processChunkAndReadFirstValue(int var1, long var2, long var4) throws IOException;

        protected abstract byte[] readSmallUncompressedValue(int var1);

        private byte[] decompressAndRead(int docId) throws IOException {
            long limit;
            long metadataEntry = this.chunkIndexFor(docId);
            int info = this._metadata.getInt(metadataEntry);
            this._docIdOffset = info & Integer.MAX_VALUE;
            this._regularChunk = this._docIdOffset == info;
            long offset = (long)this._metadata.getInt(metadataEntry + 4L) & 0xFFFFFFFFL;
            if (this._metadata.size() - 8L > metadataEntry) {
                this._nextDocIdOffset = this._metadata.getInt(metadataEntry + 8L) & Integer.MAX_VALUE;
                limit = (long)this._metadata.getInt(metadataEntry + 8L + 4L) & 0xFFFFFFFFL;
            } else {
                this._nextDocIdOffset = Integer.MAX_VALUE;
                limit = this._chunks.size();
            }
            return this.processChunkAndReadFirstValue(docId, offset, limit);
        }
    }
}

