/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.indexsegment.mutable.IntermediateSegment;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;

public class IntermediateSegmentRecordReader
implements RecordReader {
    private final IntermediateSegment _intermediateSegment;
    private final int _numDocs;
    private int _nextDocId = 0;

    public IntermediateSegmentRecordReader(IntermediateSegment intermediateSegment) {
        this._intermediateSegment = intermediateSegment;
        this._numDocs = intermediateSegment.getNumDocsIndexed();
    }

    public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
    }

    public boolean hasNext() {
        return this._nextDocId < this._numDocs;
    }

    public GenericRow next() throws IOException {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) throws IOException {
        return this._intermediateSegment.getRecord(this._nextDocId++, reuse);
    }

    public void rewind() throws IOException {
        this._nextDocId = 0;
    }

    public void close() throws IOException {
        this._intermediateSegment.destroy();
    }

    public IntermediateSegment getIntermediateSegment() {
        return this._intermediateSegment;
    }
}

