/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree;

import java.util.Iterator;
import org.apache.pinot.segment.spi.index.startree.StarTreeNode;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class OffHeapStarTreeNode
implements StarTreeNode {
    public static final int NUM_SERIALIZABLE_FIELDS = 7;
    public static final int SERIALIZABLE_SIZE_IN_BYTES = 28;
    private final PinotDataBuffer _dataBuffer;
    private final int _dimensionId;
    private final int _dimensionValue;
    private final int _startDocId;
    private final int _endDocId;
    private final int _aggregatedDocId;
    private final int _firstChildId;
    private final int _lastChildId;

    public OffHeapStarTreeNode(PinotDataBuffer dataBuffer, int nodeId) {
        this._dataBuffer = dataBuffer;
        long offset = (long)nodeId * 28L;
        this._dimensionId = dataBuffer.getInt(offset);
        this._dimensionValue = dataBuffer.getInt(offset += 4L);
        this._startDocId = dataBuffer.getInt(offset += 4L);
        this._endDocId = dataBuffer.getInt(offset += 4L);
        this._aggregatedDocId = dataBuffer.getInt(offset += 4L);
        this._firstChildId = dataBuffer.getInt(offset += 4L);
        this._lastChildId = dataBuffer.getInt(offset += 4L);
    }

    public int getDimensionId() {
        return this._dimensionId;
    }

    public int getDimensionValue() {
        return this._dimensionValue;
    }

    public int getChildDimensionId() {
        if (this._firstChildId == -1) {
            return -1;
        }
        return this._dataBuffer.getInt((long)this._firstChildId * 28L);
    }

    public int getStartDocId() {
        return this._startDocId;
    }

    public int getEndDocId() {
        return this._endDocId;
    }

    public int getAggregatedDocId() {
        return this._aggregatedDocId;
    }

    public int getNumChildren() {
        if (this._firstChildId == -1) {
            return 0;
        }
        return this._lastChildId - this._firstChildId + 1;
    }

    public boolean isLeaf() {
        return this._firstChildId == -1;
    }

    public StarTreeNode getChildForDimensionValue(int dimensionValue) {
        if (this.isLeaf()) {
            return null;
        }
        if (dimensionValue == -1) {
            OffHeapStarTreeNode firstNode = new OffHeapStarTreeNode(this._dataBuffer, this._firstChildId);
            if (firstNode.getDimensionValue() == -1) {
                return firstNode;
            }
            return null;
        }
        int low = this._firstChildId;
        int high = this._lastChildId;
        while (low <= high) {
            int mid = (low + high) / 2;
            OffHeapStarTreeNode midNode = new OffHeapStarTreeNode(this._dataBuffer, mid);
            int midValue = midNode.getDimensionValue();
            if (midValue == dimensionValue) {
                return midNode;
            }
            if (midValue < dimensionValue) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return null;
    }

    public Iterator<OffHeapStarTreeNode> getChildrenIterator() {
        return new Iterator<OffHeapStarTreeNode>(){
            private int _currentChildId;
            {
                this._currentChildId = OffHeapStarTreeNode.this._firstChildId;
            }

            @Override
            public boolean hasNext() {
                return this._currentChildId <= OffHeapStarTreeNode.this._lastChildId;
            }

            @Override
            public OffHeapStarTreeNode next() {
                return new OffHeapStarTreeNode(OffHeapStarTreeNode.this._dataBuffer, this._currentChildId++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

