/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.spi.config.table.UpsertConfig;

@ThreadSafe
public class TableUpsertMetadataManager {
    private final Map<Integer, PartitionUpsertMetadataManager> _partitionMetadataManagerMap = new ConcurrentHashMap<Integer, PartitionUpsertMetadataManager>();
    private final String _tableNameWithType;
    private final ServerMetrics _serverMetrics;
    private final PartialUpsertHandler _partialUpsertHandler;
    private final UpsertConfig.HashFunction _hashFunction;

    public TableUpsertMetadataManager(String tableNameWithType, ServerMetrics serverMetrics, @Nullable PartialUpsertHandler partialUpsertHandler, UpsertConfig.HashFunction hashFunction) {
        this._tableNameWithType = tableNameWithType;
        this._serverMetrics = serverMetrics;
        this._partialUpsertHandler = partialUpsertHandler;
        this._hashFunction = hashFunction;
    }

    public PartitionUpsertMetadataManager getOrCreatePartitionManager(int partitionId) {
        return this._partitionMetadataManagerMap.computeIfAbsent(partitionId, k -> new PartitionUpsertMetadataManager(this._tableNameWithType, (int)k, this._serverMetrics, this._partialUpsertHandler, this._hashFunction));
    }
}

