/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.local.realtime.impl.dictionary.OffHeapMutableBytesStore;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.FSTFlags;

public final class ImmutableFST
extends FST {
    public static final byte DEFAULT_FILLER = 95;
    public static final byte DEFAULT_ANNOTATION = 43;
    public static final byte VERSION = 5;
    public static final int BIT_FINAL_ARC = 1;
    public static final int BIT_LAST_ARC = 2;
    public static final int BIT_TARGET_NEXT = 4;
    public static final int ADDRESS_OFFSET = 1;
    private static final int PER_BUFFER_SIZE = 16;
    public final OffHeapMutableBytesStore _mutableBytesStore;
    public final int _nodeDataLength;
    public final int _gotoLength;
    public final byte _filler;
    public final byte _annotation;
    public Map<Integer, Integer> _outputSymbols;
    private Set<FSTFlags> _flags;

    ImmutableFST(InputStream stream, boolean hasOutputSymbols, PinotDataBufferMemoryManager memoryManager) throws IOException {
        int outputSymbolsLength;
        byte[] outputSymbolsBuffer;
        DataInputStream in = new DataInputStream(stream);
        this._filler = in.readByte();
        this._annotation = in.readByte();
        byte hgtl = in.readByte();
        this._mutableBytesStore = new OffHeapMutableBytesStore(memoryManager, "ImmutableFST");
        this._flags = EnumSet.of(FSTFlags.FLEXIBLE, FSTFlags.STOPBIT, FSTFlags.NEXTBIT);
        if ((hgtl & 0xF0) != 0) {
            this._flags.add(FSTFlags.NUMBERS);
        }
        this._flags = Collections.unmodifiableSet(this._flags);
        this._nodeDataLength = hgtl >>> 4 & 0xF;
        this._gotoLength = hgtl & 0xF;
        if (hasOutputSymbols && (outputSymbolsBuffer = ImmutableFST.readRemaining(in, outputSymbolsLength = in.readInt())).length > 0) {
            String outputSymbolsSerialized = new String(outputSymbolsBuffer);
            this._outputSymbols = this.buildMap(outputSymbolsSerialized);
        }
        this.readRemaining(in);
    }

    private void readRemaining(InputStream in) throws IOException {
        byte[] buffer = new byte[16];
        while (in.read(buffer) >= 0) {
            this._mutableBytesStore.add(buffer);
        }
    }

    @Override
    public int getRootNode() {
        int epsilonNode = this.skipArc(this.getFirstArc(0));
        return this.getDestinationNodeOffset(this.getFirstArc(epsilonNode));
    }

    @Override
    public int getFirstArc(int node) {
        return this._nodeDataLength + node;
    }

    @Override
    public int getNextArc(int arc) {
        if (this.isArcLast(arc)) {
            return 0;
        }
        return this.skipArc(arc);
    }

    @Override
    public int getArc(int node, byte label) {
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (this.getArcLabel(arc) == label) {
                return arc;
            }
            arc = this.getNextArc(arc);
        }
        return 0;
    }

    @Override
    public int getEndNode(int arc) {
        return this.getDestinationNodeOffset(arc);
    }

    @Override
    public byte getArcLabel(int arc) {
        return this.getByte(arc, 0);
    }

    @Override
    public int getOutputSymbol(int arc) {
        return this._outputSymbols.get(arc);
    }

    @Override
    public boolean isArcFinal(int arc) {
        return (this.getByte(arc, 1) & 1) != 0;
    }

    @Override
    public boolean isArcTerminal(int arc) {
        return 0 == this.getDestinationNodeOffset(arc);
    }

    @Override
    public int getRightLanguageCount(int node) {
        assert (this.getFlags().contains((Object)FSTFlags.NUMBERS)) : "This FST was not compiled with NUMBERS.";
        return this.decodeFromBytes(node, this._nodeDataLength);
    }

    @Override
    public Set<FSTFlags> getFlags() {
        return this._flags;
    }

    @Override
    public boolean isArcLast(int arc) {
        return (this.getByte(arc, 1) & 2) != 0;
    }

    public boolean isNextSet(int arc) {
        return (this.getByte(arc, 1) & 4) != 0;
    }

    private int decodeFromBytes(int start, int n) {
        int r = 0;
        int i = n;
        while (--i >= 0) {
            int seek = start + i;
            int actualArcOffset = seek >= 16 ? seek / 16 : 0;
            int bufferOffset = seek >= 16 ? seek - actualArcOffset * 16 : seek;
            byte[] inputData = this._mutableBytesStore.get(actualArcOffset);
            r = r << 8 | inputData[bufferOffset] & 0xFF;
        }
        return r;
    }

    private int getDestinationNodeOffset(int arc) {
        if (this.isNextSet(arc)) {
            return this.skipArc(arc);
        }
        return this.decodeFromBytes(arc + 1, this._gotoLength) >>> 3;
    }

    private int skipArc(int offset) {
        return offset + (this.isNextSet(offset) ? 2 : 1 + this._gotoLength);
    }

    private byte getByte(int seek, int offset) {
        int actualArcOffset = seek >= 16 ? seek / 16 : 0;
        int bufferOffset = seek >= 16 ? seek - actualArcOffset * 16 : seek;
        byte[] retVal = this._mutableBytesStore.get(actualArcOffset);
        int target = bufferOffset + offset;
        if (target >= 16) {
            retVal = this._mutableBytesStore.get(actualArcOffset + 1);
            target -= 16;
        }
        return retVal[target];
    }
}

