/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.ImmutableFST;
import org.apache.pinot.segment.local.utils.nativefst.utils.RegexpMatcher;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFSTIndexReader
implements TextIndexReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeFSTIndexReader.class);
    private final FST _fst;

    public NativeFSTIndexReader(PinotDataBuffer dataBuffer) throws IOException {
        ByteBuffer byteBuffer = dataBuffer.toDirectByteBuffer(0L, (int)dataBuffer.size());
        this._fst = FST.read((InputStream)new ByteBufferInputStream(Collections.singletonList(byteBuffer)), ImmutableFST.class, true);
    }

    public MutableRoaringBitmap getDocIds(String searchQuery) {
        throw new UnsupportedOperationException("NativeFSTIndexReader only supports getDictIds currently");
    }

    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        try {
            RoaringBitmapWriter writer = RoaringBitmapWriter.bufferWriter().get();
            RegexpMatcher.regexMatch(searchQuery, this._fst, arg_0 -> ((RoaringBitmapWriter)writer).add(arg_0));
            return (ImmutableRoaringBitmap)writer.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while matching regex: " + searchQuery, e);
        }
    }

    public void close() throws IOException {
    }
}

