/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Automaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.BasicAutomata;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;
import org.apache.pinot.segment.local.utils.nativefst.automaton.StatePair;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;

public final class BasicOperations {
    private BasicOperations() {
    }

    public static Automaton concatenate(List<Automaton> l) {
        if (l.isEmpty()) {
            return BasicAutomata.makeEmptyString();
        }
        boolean allSingleton = true;
        for (Automaton automaton : l) {
            if (automaton.isSingleton()) continue;
            allSingleton = false;
            break;
        }
        if (allSingleton) {
            StringBuilder b = new StringBuilder();
            for (Automaton a : l) {
                b.append(a._singleton);
            }
            return BasicAutomata.makeString(b.toString());
        }
        for (Automaton automaton : l) {
            if (!automaton.isEmpty()) continue;
            return BasicAutomata.makeEmpty();
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Automaton a : l) {
            ids.add(System.identityHashCode(a));
        }
        boolean bl = ids.size() != l.size();
        Automaton b = l.get(0);
        b = bl ? b.cloneExpanded() : b.cloneExpandedIfRequired();
        Set<State> ac = b.getAcceptStates();
        boolean first = true;
        for (Automaton a : l) {
            if (first) {
                first = false;
                continue;
            }
            if (a.isEmptyString()) continue;
            Automaton aa = a;
            aa = bl ? aa.cloneExpanded() : aa.cloneExpandedIfRequired();
            Set<State> ns = aa.getAcceptStates();
            for (State s : ac) {
                s._accept = false;
                s.addEpsilon(aa._initial);
                if (!s._accept) continue;
                ns.add(s);
            }
            ac = ns;
        }
        b._deterministic = false;
        b.clearHashCode();
        b.checkMinimizeAlways();
        return b;
    }

    public static Automaton optional(Automaton a) {
        a = a.cloneExpandedIfRequired();
        State s = new State();
        s.addEpsilon(a._initial);
        s._accept = true;
        a._initial = s;
        a._deterministic = false;
        a.clearHashCode();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton repeat(Automaton a) {
        a = a.cloneExpanded();
        State s = new State();
        s._accept = true;
        s.addEpsilon(a._initial);
        for (State p : a.getAcceptStates()) {
            p.addEpsilon(s);
        }
        a._initial = s;
        a._deterministic = false;
        a.clearHashCode();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton repeat(Automaton a, int min) {
        if (min == 0) {
            return BasicOperations.repeat(a);
        }
        ArrayList<Automaton> as = new ArrayList<Automaton>();
        while (min-- > 0) {
            as.add(a);
        }
        as.add(BasicOperations.repeat(a));
        return BasicOperations.concatenate(as);
    }

    public static Automaton repeat(Automaton a, int min, int max) {
        Automaton b;
        if (min > max) {
            return BasicAutomata.makeEmpty();
        }
        max -= min;
        a.expandSingleton();
        if (min == 0) {
            b = BasicAutomata.makeEmptyString();
        } else if (min == 1) {
            b = a.clone();
        } else {
            ArrayList<Automaton> as = new ArrayList<Automaton>();
            while (min-- > 0) {
                as.add(a);
            }
            b = BasicOperations.concatenate(as);
        }
        if (max > 0) {
            Automaton d = a.clone();
            while (--max > 0) {
                Automaton c = a.clone();
                for (State p : c.getAcceptStates()) {
                    p.addEpsilon(d._initial);
                }
                d = c;
            }
            for (State p : b.getAcceptStates()) {
                p.addEpsilon(d._initial);
            }
            b._deterministic = false;
            b.clearHashCode();
            b.checkMinimizeAlways();
        }
        return b;
    }

    public static Automaton complement(Automaton a) {
        a = a.cloneExpandedIfRequired();
        a.determinize();
        a.totalize();
        for (State p : a.getStates()) {
            p._accept = !p._accept;
        }
        a.removeDeadTransitions();
        return a;
    }

    public static Automaton minus(Automaton a1, Automaton a2) {
        if (a1.isEmpty() || a1 == a2) {
            return BasicAutomata.makeEmpty();
        }
        if (a2.isEmpty()) {
            return a1.cloneIfRequired();
        }
        if (a1.isSingleton()) {
            if (a2.run(a1._singleton)) {
                return BasicAutomata.makeEmpty();
            }
            return a1.cloneIfRequired();
        }
        return BasicOperations.intersection(a1, a2.complement());
    }

    public static Automaton intersection(Automaton a1, Automaton a2) {
        if (a1.isSingleton()) {
            if (a2.run(a1._singleton)) {
                return a1.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (a2.isSingleton()) {
            if (a1.run(a2._singleton)) {
                return a2.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (a1 == a2) {
            return a1.cloneIfRequired();
        }
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        Automaton c = new Automaton();
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        StatePair p = new StatePair(c._initial, a1._initial, a2._initial);
        worklist.add(p);
        newstates.put(p, p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            p._parentState._accept = p._firstState._accept && p._secondState._accept;
            Transition[] t1 = transitions1[p._firstState._number];
            Transition[] t2 = transitions2[p._secondState._number];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2]._max < t1[n1]._min) {
                    ++b2;
                }
                for (int n2 = b2; n2 < t2.length && t1[n1]._max >= t2[n2]._min; ++n2) {
                    if (t2[n2]._max < t1[n1]._min) continue;
                    StatePair q = new StatePair(t1[n1]._to, t2[n2]._to);
                    StatePair r = (StatePair)newstates.get(q);
                    if (r == null) {
                        q._parentState = new State();
                        worklist.add(q);
                        newstates.put(q, q);
                        r = q;
                    }
                    char min = t1[n1]._min > t2[n2]._min ? t1[n1]._min : t2[n2]._min;
                    char max = t1[n1]._max < t2[n2]._max ? t1[n1]._max : t2[n2]._max;
                    p._parentState._transitionSet.add(new Transition(min, max, r._parentState));
                }
            }
        }
        c._deterministic = a1._deterministic && a2._deterministic;
        c.removeDeadTransitions();
        c.checkMinimizeAlways();
        return c;
    }

    public static boolean subsetOf(Automaton a1, Automaton a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1.isSingleton()) {
            if (a2.isSingleton()) {
                return a1._singleton.equals(a2._singleton);
            }
            return a2.run(a1._singleton);
        }
        a2.determinize();
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashSet<StatePair> visited = new HashSet<StatePair>();
        StatePair p = new StatePair(a1._initial, a2._initial);
        worklist.add(p);
        visited.add(p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            if (p._firstState._accept && !p._secondState._accept) {
                return false;
            }
            Transition[] t1 = transitions1[p._firstState._number];
            Transition[] t2 = transitions2[p._secondState._number];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2]._max < t1[n1]._min) {
                    ++b2;
                }
                char min1 = t1[n1]._min;
                char max1 = t1[n1]._max;
                for (int n2 = b2; n2 < t2.length && t1[n1]._max >= t2[n2]._min; ++n2) {
                    if (t2[n2]._min > min1) {
                        return false;
                    }
                    if (t2[n2]._max < '\uffff') {
                        min1 = t2[n2]._max + '\u0001';
                    } else {
                        min1 = '\uffff';
                        max1 = '\u0000';
                    }
                    StatePair q = new StatePair(t1[n1]._to, t2[n2]._to);
                    if (visited.contains(q)) continue;
                    worklist.add(q);
                    visited.add(q);
                }
                if (min1 > max1) continue;
                return false;
            }
        }
        return true;
    }

    public static Automaton union(Automaton a1, Automaton a2) {
        if (a1.isSingleton() && a2.isSingleton() && a1._singleton.equals(a2._singleton) || a1 == a2) {
            return a1.cloneIfRequired();
        }
        a1 = a1.cloneExpandedIfRequired();
        a2 = a2.cloneExpandedIfRequired();
        State s = new State();
        s.addEpsilon(a1._initial);
        s.addEpsilon(a2._initial);
        a1._initial = s;
        a1._deterministic = false;
        a1.clearHashCode();
        a1.checkMinimizeAlways();
        return a1;
    }

    public static Automaton union(Collection<Automaton> l) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Automaton a : l) {
            ids.add(System.identityHashCode(a));
        }
        boolean hasAliases = ids.size() != l.size();
        State s = new State();
        for (Automaton b : l) {
            if (b.isEmpty()) continue;
            Automaton bb = b;
            bb = hasAliases ? bb.cloneExpanded() : bb.cloneExpandedIfRequired();
            s.addEpsilon(bb._initial);
        }
        Automaton a = new Automaton();
        a._initial = s;
        a._deterministic = false;
        a.clearHashCode();
        a.checkMinimizeAlways();
        return a;
    }

    public static void determinize(Automaton a) {
        if (a._deterministic || a.isSingleton()) {
            return;
        }
        HashSet<State> initialset = new HashSet<State>();
        initialset.add(a._initial);
        BasicOperations.determinize(a, initialset);
    }

    static void determinize(Automaton a, Set<State> initialset) {
        char[] points = a.getStartPoints();
        LinkedList<Set<State>> worklist = new LinkedList<Set<State>>();
        HashMap<Set<State>, State> newstate = new HashMap<Set<State>, State>();
        worklist.add(initialset);
        a._initial = new State();
        newstate.put(initialset, a._initial);
        while (worklist.size() > 0) {
            Set s = (Set)worklist.removeFirst();
            State r = (State)newstate.get(s);
            for (State q : s) {
                if (!q._accept) continue;
                r._accept = true;
                break;
            }
            for (int n = 0; n < points.length; ++n) {
                HashSet<State> p = new HashSet<State>();
                for (State q : s) {
                    for (Transition t : q._transitionSet) {
                        if (t._min > points[n] || points[n] > t._max) continue;
                        p.add(t._to);
                    }
                }
                if (p.isEmpty()) continue;
                State q = (State)newstate.get(p);
                if (q == null) {
                    worklist.add(p);
                    q = new State();
                    newstate.put(p, q);
                }
                char min = points[n];
                char max = n + 1 < points.length ? (char)((char)(points[n + 1] - '\u0001')) : (char)'\uffff';
                r._transitionSet.add(new Transition(min, max, q));
            }
        }
        a._deterministic = true;
        a.removeDeadTransitions();
    }

    public static void addEpsilons(Automaton a, Collection<StatePair> pairs) {
        a.expandSingleton();
        HashMap<State, HashSet<State>> forward = new HashMap<State, HashSet<State>>();
        HashMap<State, HashSet<State>> back = new HashMap<State, HashSet<State>>();
        for (StatePair p : pairs) {
            HashSet<State> to = (HashSet<State>)forward.get(p._firstState);
            if (to == null) {
                to = new HashSet<State>();
                forward.put(p._firstState, to);
            }
            to.add(p._secondState);
            HashSet<State> from = (HashSet<State>)back.get(p._secondState);
            if (from == null) {
                from = new HashSet<State>();
                back.put(p._secondState, from);
            }
            from.add(p._firstState);
        }
        LinkedList<StatePair> worklist = new LinkedList<StatePair>(pairs);
        HashSet<StatePair> workset = new HashSet<StatePair>(pairs);
        while (!worklist.isEmpty()) {
            StatePair p = worklist.removeFirst();
            workset.remove(p);
            HashSet to = (HashSet)forward.get(p._secondState);
            HashSet from = (HashSet)back.get(p._firstState);
            if (to == null) continue;
            for (State s : to) {
                StatePair pp = new StatePair(p._firstState, s);
                if (pairs.contains(pp)) continue;
                pairs.add(pp);
                ((HashSet)forward.get(p._firstState)).add(s);
                ((HashSet)back.get(s)).add(p._firstState);
                worklist.add(pp);
                workset.add(pp);
                if (from == null) continue;
                for (State q : from) {
                    StatePair qq = new StatePair(q, p._firstState);
                    if (workset.contains(qq)) continue;
                    worklist.add(qq);
                    workset.add(qq);
                }
            }
        }
        for (StatePair p : pairs) {
            p._firstState.addEpsilon(p._secondState);
        }
        a._deterministic = false;
        a.clearHashCode();
        a.checkMinimizeAlways();
    }

    public static boolean isEmptyString(Automaton a) {
        if (a.isSingleton()) {
            return a._singleton.length() == 0;
        }
        return a._initial._accept && a._initial._transitionSet.isEmpty();
    }

    public static boolean isEmpty(Automaton a) {
        if (a.isSingleton()) {
            return false;
        }
        return !a._initial._accept && a._initial._transitionSet.isEmpty();
    }

    public static boolean run(Automaton a, String s) {
        if (a.isSingleton()) {
            return s.equals(a._singleton);
        }
        if (a._deterministic) {
            State p = a._initial;
            for (int i = 0; i < s.length(); ++i) {
                State q = p.step(s.charAt(i));
                if (q == null) {
                    return false;
                }
                p = q;
            }
            return p._accept;
        }
        Set<State> states = a.getStates();
        Automaton.setStateNumbers(states);
        LinkedList<State> pp = new LinkedList<State>();
        LinkedList<State> ppOther = new LinkedList<State>();
        BitSet bb = new BitSet(states.size());
        BitSet bbOther = new BitSet(states.size());
        pp.add(a._initial);
        ArrayList<State> dest = new ArrayList<State>();
        boolean accept = a._initial._accept;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            accept = false;
            ppOther.clear();
            bbOther.clear();
            for (State p : pp) {
                dest.clear();
                p.step(c, dest);
                for (State q : dest) {
                    if (q._accept) {
                        accept = true;
                    }
                    if (bbOther.get(q._number)) continue;
                    bbOther.set(q._number);
                    ppOther.add(q);
                }
            }
            LinkedList<State> tp = pp;
            pp = ppOther;
            ppOther = tp;
            BitSet tb = bb;
            bb = bbOther;
            bbOther = tb;
        }
        return accept;
    }
}

