/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Automaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.AutomatonMatcher;
import org.apache.pinot.segment.local.utils.nativefst.automaton.SpecialOperations;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;

public class RunAutomaton
implements Serializable {
    int _size;
    boolean[] _accept;
    int _initial;
    int[] _transitions;
    char[] _points;
    int[] _classmap;

    public RunAutomaton(Automaton a) {
        this(a, true);
    }

    public RunAutomaton(Automaton a, boolean tableize) {
        a.determinize();
        this._points = a.getStartPoints();
        Set<State> states = a.getStates();
        Automaton.setStateNumbers(states);
        this._initial = a._initial._number;
        this._size = states.size();
        this._accept = new boolean[this._size];
        this._transitions = new int[this._size * this._points.length];
        for (int n = 0; n < this._size * this._points.length; ++n) {
            this._transitions[n] = -1;
        }
        for (State s : states) {
            int n = s._number;
            this._accept[n] = s._accept;
            for (int c = 0; c < this._points.length; ++c) {
                State q = s.step(this._points[c]);
                if (q == null) continue;
                this._transitions[n * this._points.length + c] = q._number;
            }
        }
        if (tableize) {
            this.setAlphabet();
        }
    }

    public static RunAutomaton load(URL url) throws IOException, ClassCastException, ClassNotFoundException {
        return RunAutomaton.load(url.openStream());
    }

    public static RunAutomaton load(InputStream stream) throws IOException, ClassCastException, ClassNotFoundException {
        ObjectInputStream s = new ObjectInputStream(stream);
        return (RunAutomaton)s.readObject();
    }

    void setAlphabet() {
        this._classmap = new int[65536];
        int i = 0;
        for (char j = '\u0000'; j <= '\uffff'; ++j) {
            if (i + 1 >= this._points.length || j == this._points[i + 1]) {
                // empty if block
            }
            this._classmap[j] = ++i;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("initial state: ").append(this._initial).append("\n");
        for (int i = 0; i < this._size; ++i) {
            b.append("state ").append(i);
            if (this._accept[i]) {
                b.append(" [accept]:\n");
            } else {
                b.append(" [reject]:\n");
            }
            for (int j = 0; j < this._points.length; ++j) {
                int k = this._transitions[i * this._points.length + j];
                if (k == -1) continue;
                char min = this._points[j];
                char max = j + 1 < this._points.length ? (char)((char)(this._points[j + 1] - '\u0001')) : (char)'\uffff';
                b.append(" ");
                Transition.appendCharString(min, b);
                if (min != max) {
                    b.append("-");
                    Transition.appendCharString(max, b);
                }
                b.append(" -> ").append(k).append("\n");
            }
        }
        return b.toString();
    }

    public int getSize() {
        return this._size;
    }

    public boolean isAccept(int state) {
        return this._accept[state];
    }

    public int getInitialState() {
        return this._initial;
    }

    int getCharClass(char c) {
        return SpecialOperations.findIndex(c, this._points);
    }

    public void store(OutputStream stream) throws IOException {
        ObjectOutputStream s = new ObjectOutputStream(stream);
        s.writeObject(this);
        s.flush();
    }

    final int getCharClass(int c) {
        int a = 0;
        int b = this._points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (this._points[d] > c) {
                b = d;
                continue;
            }
            if (this._points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    public final int step(int state, int c) {
        if (c >= this._classmap.length) {
            return this._transitions[state * this._points.length + this.getCharClass(c)];
        }
        return this._transitions[state * this._points.length + this._classmap[c]];
    }

    public int step(int state, char c) {
        if (this._classmap == null) {
            return this._transitions[state * this._points.length + this.getCharClass(c)];
        }
        return this._transitions[state * this._points.length + this._classmap[c - '\u0000']];
    }

    public boolean run(String s) {
        int p = this._initial;
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if ((p = this.step(p, s.charAt(i))) != -1) continue;
            return false;
        }
        return this._accept[p];
    }

    public int run(String s, int offset) {
        int p = this._initial;
        int l = s.length();
        int max = -1;
        int r = 0;
        while (offset <= l) {
            if (this._accept[p]) {
                max = r;
            }
            if (offset == l || (p = this.step(p, s.charAt(offset))) == -1) break;
            ++offset;
            ++r;
        }
        return max;
    }

    public AutomatonMatcher newMatcher(CharSequence s) {
        return new AutomatonMatcher(s, this);
    }

    public AutomatonMatcher newMatcher(CharSequence s, int startOffset, int endOffset) {
        return new AutomatonMatcher(s.subSequence(startOffset, endOffset), this);
    }
}

